/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.compaction;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationTypeHelper;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FilePrefix;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.IteratorConfigUtil;
import org.apache.accumulo.core.iteratorsImpl.system.ColumnFamilySkippingIterator;
import org.apache.accumulo.core.iteratorsImpl.system.DeletingIterator;
import org.apache.accumulo.core.iteratorsImpl.system.IterationInterruptedException;
import org.apache.accumulo.core.iteratorsImpl.system.MultiIterator;
import org.apache.accumulo.core.iteratorsImpl.system.TimeSettingIterator;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionReason;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.compaction.CompactionInfo;
import org.apache.accumulo.server.compaction.CompactionStats;
import org.apache.accumulo.server.compaction.CountingIterator;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironment;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReportingIterator;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCompactor
implements Callable<CompactionStats> {
    private static final Logger log = LoggerFactory.getLogger(FileCompactor.class);
    private static final AtomicLong nextCompactorID = new AtomicLong(0L);
    private final Map<StoredTabletFile, DataFileValue> filesToCompact;
    private final TabletFile outputFile;
    private final boolean propagateDeletes;
    private final AccumuloConfiguration acuTableConf;
    private final CompactionEnv env;
    private final VolumeManager fs;
    protected final KeyExtent extent;
    private final List<IteratorSetting> iterators;
    private final CryptoService cryptoService;
    private String currentLocalityGroup = "";
    private volatile long startTime = -1L;
    private final AtomicLong currentEntriesRead = new AtomicLong(0L);
    private final AtomicLong currentEntriesWritten = new AtomicLong(0L);
    private final AtomicLong lastRecordedEntriesRead = new AtomicLong(0L);
    private final AtomicLong lastRecordedEntriesWritten = new AtomicLong(0L);
    private static final LongAdder totalEntriesRead = new LongAdder();
    private static final LongAdder totalEntriesWritten = new LongAdder();
    private static volatile long lastUpdateTime = 0L;
    private final DateFormat dateFormatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private final long compactorID = nextCompactorID.getAndIncrement();
    private volatile Thread thread;
    private final ServerContext context;
    private final AtomicBoolean interruptFlag = new AtomicBoolean(false);
    protected static final Set<FileCompactor> runningCompactions = Collections.synchronizedSet(new HashSet());

    public synchronized void interrupt() {
        this.interruptFlag.set(true);
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    private synchronized ThreadClearer setThread() {
        this.thread = Thread.currentThread();
        return new ThreadClearer();
    }

    private synchronized void clearThread() throws InterruptedException {
        Preconditions.checkState((this.thread == Thread.currentThread() ? 1 : 0) != 0);
        this.thread = null;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    Thread getThread() {
        return this.thread;
    }

    public long getCompactorID() {
        return this.compactorID;
    }

    private synchronized void setLocalityGroup(String name) {
        this.currentLocalityGroup = name;
    }

    public synchronized String getCurrentLocalityGroup() {
        return this.currentLocalityGroup;
    }

    private void clearCurrentEntryCounts() {
        this.currentEntriesRead.set(0L);
        this.currentEntriesWritten.set(0L);
    }

    private void updateGlobalEntryCounts() {
        this.updateTotalEntries(this.currentEntriesRead, this.lastRecordedEntriesRead, totalEntriesRead);
        this.updateTotalEntries(this.currentEntriesWritten, this.lastRecordedEntriesWritten, totalEntriesWritten);
    }

    private void updateTotalEntries(AtomicLong current, AtomicLong recorded, LongAdder total) {
        long currentCount = current.get();
        long lastRecorded = recorded.getAndUpdate(recordedValue -> Math.max(recordedValue, currentCount));
        if (lastRecorded < currentCount) {
            total.add(currentCount - lastRecorded);
        }
    }

    public static long getTotalEntriesWritten() {
        FileCompactor.updateTotalEntries();
        return totalEntriesWritten.sum();
    }

    public static long getTotalEntriesRead() {
        FileCompactor.updateTotalEntries();
        return totalEntriesRead.sum();
    }

    private static void updateTotalEntries() {
        long currentTime = System.nanoTime();
        if (currentTime - lastUpdateTime < Duration.ofMillis(100L).toNanos()) {
            return;
        }
        runningCompactions.forEach(FileCompactor::updateGlobalEntryCounts);
        lastUpdateTime = currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CompactionInfo> getRunningCompactions() {
        ArrayList<CompactionInfo> compactions = new ArrayList<CompactionInfo>();
        Set<FileCompactor> set = runningCompactions;
        synchronized (set) {
            for (FileCompactor compactor : runningCompactions) {
                compactions.add(new CompactionInfo(compactor));
            }
        }
        return compactions;
    }

    public FileCompactor(ServerContext context, KeyExtent extent, Map<StoredTabletFile, DataFileValue> files, TabletFile outputFile, boolean propagateDeletes, CompactionEnv env, List<IteratorSetting> iterators, AccumuloConfiguration tableConfiguation, CryptoService cs) {
        this.context = context;
        this.extent = extent;
        this.fs = context.getVolumeManager();
        this.acuTableConf = tableConfiguation;
        this.filesToCompact = files;
        this.outputFile = outputFile;
        this.propagateDeletes = propagateDeletes;
        this.env = env;
        this.iterators = iterators;
        this.cryptoService = cs;
    }

    public VolumeManager getVolumeManager() {
        return this.fs;
    }

    public KeyExtent getExtent() {
        return this.extent;
    }

    protected String getOutputFile() {
        return this.outputFile.toString();
    }

    protected Map<String, Set<ByteSequence>> getLocalityGroups(AccumuloConfiguration acuTableConf) throws IOException {
        try {
            return LocalityGroupUtil.getLocalityGroups((AccumuloConfiguration)acuTableConf);
        }
        catch (LocalityGroupUtil.LocalityGroupConfigurationError e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactionStats call() throws IOException, CompactionCanceledException, InterruptedException, ReflectiveOperationException {
        FileSKVWriter mfw = null;
        CompactionStats majCStats = new CompactionStats();
        this.startTime = System.nanoTime();
        boolean remove = runningCompactions.add(this);
        String threadStartDate = this.dateFormatter.format(new Date());
        this.clearCurrentEntryCounts();
        String oldThreadName = Thread.currentThread().getName();
        String newThreadName = "MajC compacting " + String.valueOf(this.extent) + " started " + threadStartDate + " file: " + String.valueOf(this.outputFile);
        Thread.currentThread().setName(newThreadName);
        try {
            CompactionStats compactionStats;
            block32: {
                ThreadClearer ignored = this.setThread();
                try {
                    FileOperations fileFactory = FileOperations.getInstance();
                    FileSystem ns = this.fs.getFileSystemByPath(this.outputFile.getPath());
                    String dropCachePrefixProperty = this.acuTableConf.get(Property.TABLE_COMPACTION_INPUT_DROP_CACHE_BEHIND);
                    EnumSet dropCacheFileTypes = ConfigurationTypeHelper.getDropCacheBehindFilePrefixes((String)dropCachePrefixProperty);
                    boolean isMinC = this.env.getIteratorScope() == IteratorUtil.IteratorScope.minc;
                    boolean dropCacheBehindOutput = !RootTable.ID.equals((Object)this.extent.tableId()) && !MetadataTable.ID.equals((Object)this.extent.tableId()) && (isMinC && this.acuTableConf.getBoolean(Property.TABLE_MINC_OUTPUT_DROP_CACHE) || !isMinC && this.acuTableConf.getBoolean(Property.TABLE_MAJC_OUTPUT_DROP_CACHE));
                    FileOperations.WriterBuilder outBuilder = fileFactory.newWriterBuilder().forFile(this.outputFile.getMetaInsert(), ns, ns.getConf(), this.cryptoService).withTableConfiguration(this.acuTableConf).withRateLimiter(this.env.getWriteLimiter());
                    if (dropCacheBehindOutput) {
                        outBuilder.dropCachesBehind();
                    }
                    mfw = outBuilder.build();
                    Map<String, Set<ByteSequence>> lGroups = this.getLocalityGroups(this.acuTableConf);
                    long t1 = System.currentTimeMillis();
                    HashSet<ByteSequence> allColumnFamilies = new HashSet<ByteSequence>();
                    if (mfw.supportsLocalityGroups()) {
                        for (Map.Entry<String, Set<ByteSequence>> entry : lGroups.entrySet()) {
                            this.setLocalityGroup(entry.getKey());
                            this.compactLocalityGroup(entry.getKey(), entry.getValue(), true, mfw, majCStats, dropCacheFileTypes);
                            allColumnFamilies.addAll((Collection<ByteSequence>)entry.getValue());
                        }
                    }
                    this.setLocalityGroup("");
                    this.compactLocalityGroup(null, allColumnFamilies, false, mfw, majCStats, dropCacheFileTypes);
                    long t2 = System.currentTimeMillis();
                    FileSKVWriter mfwTmp = mfw;
                    mfw = null;
                    try {
                        mfwTmp.close();
                    }
                    catch (IOException ex) {
                        if (!this.fs.deleteRecursively(this.outputFile.getPath()) && this.fs.exists(this.outputFile.getPath())) {
                            log.error("Unable to delete {}", (Object)this.outputFile);
                        }
                        throw ex;
                    }
                    log.trace(String.format("Compaction %s %,d read | %,d written | %,6d entries/sec | %,6.3f secs | %,12d bytes | %9.3f byte/sec", this.extent, majCStats.getEntriesRead(), majCStats.getEntriesWritten(), (int)((double)majCStats.getEntriesRead() / ((double)(t2 - t1) / 1000.0)), (double)(t2 - t1) / 1000.0, mfwTmp.getLength(), (double)mfwTmp.getLength() / ((double)(t2 - t1) / 1000.0)));
                    majCStats.setFileSize(mfwTmp.getLength());
                    compactionStats = majCStats;
                    if (ignored == null) break block32;
                }
                catch (Throwable fileFactory) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable ns) {
                                fileFactory.addSuppressed(ns);
                            }
                        }
                        throw fileFactory;
                    }
                    catch (CompactionCanceledException e) {
                        log.debug("Compaction canceled {}", (Object)this.extent);
                        throw e;
                    }
                    catch (IterationInterruptedException iie) {
                        if (!this.env.isCompactionEnabled()) {
                            log.debug("Compaction canceled {}", (Object)this.extent);
                            throw new CompactionCanceledException();
                        }
                        log.debug("RFile interrupted {}", (Object)this.extent);
                        throw iie;
                    }
                    catch (IOException | RuntimeException e) {
                        Collection inputFileNames = Collections2.transform(this.getFilesToCompact(), TabletFile::getFileName);
                        String outputFileName = this.outputFile.getFileName();
                        log.error("Compaction error. Compaction info: extent: {}, input files: {}, output file: {}, iterators: {}, start date: {}", new Object[]{this.getExtent(), inputFileNames, outputFileName, this.getIterators(), threadStartDate, e});
                        throw e;
                    }
                }
                ignored.close();
            }
            return compactionStats;
        }
        finally {
            block33: {
                Thread.currentThread().setName(oldThreadName);
                if (remove) {
                    runningCompactions.remove(this);
                }
                this.updateGlobalEntryCounts();
                try {
                    if (mfw == null) break block33;
                    try {
                        mfw.close();
                    }
                    finally {
                        if (!this.fs.deleteRecursively(this.outputFile.getPath()) && this.fs.exists(this.outputFile.getPath())) {
                            log.error("Unable to delete {}", (Object)this.outputFile);
                        }
                    }
                }
                catch (IOException | RuntimeException e) {
                    if (this.env.isCompactionEnabled()) {
                        log.warn("{}", (Object)e.getMessage(), (Object)e);
                    }
                    log.debug("{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private List<SortedKeyValueIterator<Key, Value>> openMapDataFiles(ArrayList<FileSKVIterator> readers, EnumSet<FilePrefix> dropCacheFilePrefixes) throws IOException {
        ArrayList<SortedKeyValueIterator<Key, Value>> iters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.filesToCompact.size());
        for (StoredTabletFile mapFile : this.filesToCompact.keySet()) {
            try {
                FileOperations fileFactory = FileOperations.getInstance();
                FileSystem fs = this.fs.getFileSystemByPath(mapFile.getPath());
                boolean dropCacheBehindCompactionInputFile = false;
                if (dropCacheFilePrefixes.containsAll(EnumSet.allOf(FilePrefix.class))) {
                    dropCacheBehindCompactionInputFile = true;
                } else {
                    FilePrefix type = FilePrefix.fromFileName((String)mapFile.getFileName());
                    if (dropCacheFilePrefixes.contains(type)) {
                        dropCacheBehindCompactionInputFile = true;
                    }
                }
                FileOperations.ReaderBuilder readerBuilder = fileFactory.newReaderBuilder().forFile(mapFile.getPathStr(), fs, fs.getConf(), this.cryptoService).withTableConfiguration(this.acuTableConf).withRateLimiter(this.env.getReadLimiter());
                if (dropCacheBehindCompactionInputFile) {
                    readerBuilder.dropCachesBehind();
                }
                FileSKVIterator reader = readerBuilder.build();
                readers.add(reader);
                ProblemReportingIterator iter = new ProblemReportingIterator(this.context, this.extent.tableId(), mapFile.getPathStr(), false, (SortedKeyValueIterator<Key, Value>)reader);
                iter.setInterruptFlag(this.interruptFlag);
                if (this.filesToCompact.get(mapFile).isTimeSet()) {
                    iter = new TimeSettingIterator((SortedKeyValueIterator)iter, this.filesToCompact.get(mapFile).getTime());
                }
                iters.add((SortedKeyValueIterator<Key, Value>)iter);
            }
            catch (Exception e) {
                ProblemReports.getInstance(this.context).report(new ProblemReport(this.extent.tableId(), ProblemType.FILE_READ, mapFile.getPathStr(), e));
                log.warn("Some problem opening map file {} {}", new Object[]{mapFile, e.getMessage(), e});
                for (FileSKVIterator reader : readers) {
                    try {
                        reader.close();
                    }
                    catch (Exception e2) {
                        log.warn("Failed to close map file", (Throwable)e2);
                    }
                }
                readers.clear();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException("Failed to open map data files", e);
            }
        }
        return iters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactLocalityGroup(String lgName, Set<ByteSequence> columnFamilies, boolean inclusive, FileSKVWriter mfw, CompactionStats majCStats, EnumSet<FilePrefix> dropCacheFilePrefixes) throws IOException, CompactionCanceledException, ReflectiveOperationException {
        block33: {
            ArrayList<FileSKVIterator> readers = new ArrayList<FileSKVIterator>(this.filesToCompact.size());
            Span compactSpan = TraceUtil.startSpan(this.getClass(), (String)"compact");
            try (Scope span = compactSpan.makeCurrent();){
                long entriesCompacted = 0L;
                List<SortedKeyValueIterator<Key, Value>> iters = this.openMapDataFiles(readers, dropCacheFilePrefixes);
                if (this.env.getIteratorScope() == IteratorUtil.IteratorScope.minc) {
                    iters.add(this.env.getMinCIterator());
                }
                CountingIterator citr = new CountingIterator((SortedKeyValueIterator<Key, Value>)new MultiIterator(iters, this.extent.toDataRange()), this.currentEntriesRead);
                SortedKeyValueIterator delIter = DeletingIterator.wrap((SortedKeyValueIterator)citr, (boolean)this.propagateDeletes, (DeletingIterator.Behavior)DeletingIterator.getBehavior((AccumuloConfiguration)this.acuTableConf));
                ColumnFamilySkippingIterator cfsi = new ColumnFamilySkippingIterator(delIter);
                SystemIteratorEnvironment iterEnv = this.env.createIteratorEnv(this.context, this.acuTableConf, this.getExtent().tableId());
                SortedKeyValueIterator<Key, Value> itr = iterEnv.getTopLevelIterator((SortedKeyValueIterator<Key, Value>)IteratorConfigUtil.convertItersAndLoad((IteratorUtil.IteratorScope)this.env.getIteratorScope(), (SortedKeyValueIterator)cfsi, (AccumuloConfiguration)this.acuTableConf, this.iterators, (IteratorEnvironment)iterEnv));
                itr.seek(this.extent.toDataRange(), columnFamilies, inclusive);
                if (inclusive) {
                    mfw.startNewLocalityGroup(lgName, columnFamilies);
                } else {
                    mfw.startDefaultLocalityGroup();
                }
                Span writeSpan = TraceUtil.startSpan(this.getClass(), (String)"write");
                try (Scope write = writeSpan.makeCurrent();){
                    while (itr.hasTop() && this.env.isCompactionEnabled()) {
                        mfw.append((Key)itr.getTopKey(), (Value)itr.getTopValue());
                        itr.next();
                        if (++entriesCompacted % 1024L != 0L) continue;
                        this.currentEntriesWritten.addAndGet(1024L);
                    }
                    if (!itr.hasTop() || this.env.isCompactionEnabled()) break block33;
                    try {
                        try {
                            mfw.close();
                        }
                        catch (IOException e) {
                            log.warn("{}", (Object)e.getMessage());
                            log.debug("{}", (Object)e.getMessage(), (Object)e);
                        }
                        this.fs.deleteRecursively(this.outputFile.getPath());
                    }
                    catch (Exception e) {
                        log.warn("Failed to delete Canceled compaction output file {}", (Object)this.outputFile, (Object)e);
                    }
                    throw new CompactionCanceledException();
                }
                finally {
                    CompactionStats lgMajcStats = new CompactionStats(citr.getCount(), entriesCompacted);
                    majCStats.add(lgMajcStats);
                    writeSpan.end();
                }
            }
            catch (Exception e) {
                TraceUtil.setException((Span)compactSpan, (Throwable)e, (boolean)true);
                throw e;
            }
            finally {
                for (FileSKVIterator reader : readers) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        log.warn("Failed to close map file", (Throwable)e);
                    }
                }
                compactSpan.end();
            }
        }
    }

    Collection<StoredTabletFile> getFilesToCompact() {
        return this.filesToCompact.keySet();
    }

    boolean hasIMM() {
        return this.env.getIteratorScope() == IteratorUtil.IteratorScope.minc;
    }

    boolean willPropagateDeletes() {
        return this.propagateDeletes;
    }

    long getEntriesRead() {
        return this.currentEntriesRead.get();
    }

    long getEntriesWritten() {
        return this.currentEntriesWritten.get();
    }

    Duration getAge() {
        if (this.startTime == -1L) {
            return Duration.ZERO;
        }
        return Duration.ofNanos(System.nanoTime() - this.startTime);
    }

    Iterable<IteratorSetting> getIterators() {
        return this.iterators;
    }

    public TCompactionReason getReason() {
        return this.env.getReason();
    }

    private class ThreadClearer
    implements AutoCloseable {
        private ThreadClearer() {
        }

        @Override
        public void close() throws InterruptedException {
            FileCompactor.this.clearThread();
        }
    }

    public static interface CompactionEnv {
        public boolean isCompactionEnabled();

        public IteratorUtil.IteratorScope getIteratorScope();

        public RateLimiter getReadLimiter();

        public RateLimiter getWriteLimiter();

        public SystemIteratorEnvironment createIteratorEnv(ServerContext var1, AccumuloConfiguration var2, TableId var3);

        public SortedKeyValueIterator<Key, Value> getMinCIterator();

        public TCompactionReason getReason();
    }

    public static class CompactionCanceledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

