/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.net.ssl.SSLServerSocket;
import javax.security.auth.callback.CallbackHandler;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.core.metrics.MetricsInfo;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.UGIAssumingTransportFactory;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPoolNames;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.rpc.ClientInfoProcessorFactory;
import org.apache.accumulo.server.rpc.CustomNonBlockingServer;
import org.apache.accumulo.server.rpc.CustomThreadedSelectorServer;
import org.apache.accumulo.server.rpc.SaslServerConnectionParams;
import org.apache.accumulo.server.rpc.SaslServerDigestCallbackHandler;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.rpc.TimedProcessor;
import org.apache.accumulo.server.rpc.UGIAssumingProcessor;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TServerUtils {
    private static final Logger log = LoggerFactory.getLogger(TServerUtils.class);
    public static final ThreadLocal<String> clientAddress = new ThreadLocal();

    public static HostAndPort[] getHostAndPorts(String hostname, IntStream ports) {
        return (HostAndPort[])ports.mapToObj(port -> HostAndPort.fromParts((String)hostname, (int)port)).toArray(HostAndPort[]::new);
    }

    static Map<Integer, Property> getReservedPorts(AccumuloConfiguration config, Property portProperty) {
        return EnumSet.allOf(Property.class).stream().filter(p -> p.getType() == PropertyType.PORT && p != portProperty).flatMap(rp -> config.getPortStream(rp).mapToObj(portNum -> new Pair((Object)portNum, rp))).filter(p -> (Integer)p.getFirst() != 0).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static ServerAddress startServer(ServerContext context, String hostname, Property portHintProperty, TProcessor processor, String serverName, String threadName, Property portSearchProperty, Property minThreadProperty, Property threadTimeOutProperty, Property timeBetweenThreadChecksProperty, Property maxMessageSizeProperty) throws UnknownHostException {
        AccumuloConfiguration config = context.getConfiguration();
        IntStream portHint = config.getPortStream(portHintProperty);
        int minThreads = 2;
        if (minThreadProperty != null) {
            minThreads = config.getCount(minThreadProperty);
        }
        long threadTimeOut = ThreadPools.DEFAULT_TIMEOUT_MILLISECS;
        if (threadTimeOutProperty != null) {
            threadTimeOut = config.getTimeInMillis(threadTimeOutProperty);
        }
        long timeBetweenThreadChecks = 1000L;
        if (timeBetweenThreadChecksProperty != null) {
            timeBetweenThreadChecks = config.getTimeInMillis(timeBetweenThreadChecksProperty);
        }
        long maxMessageSize = Integer.MAX_VALUE;
        if (maxMessageSizeProperty != null) {
            maxMessageSize = config.getAsBytes(maxMessageSizeProperty);
        }
        boolean portSearch = false;
        if (portSearchProperty != null) {
            portSearch = config.getBoolean(portSearchProperty);
        }
        int backlog = config.getCount(Property.RPC_BACKLOG);
        ThriftServerType serverType = context.getThriftServerType();
        if (serverType == ThriftServerType.SASL) {
            processor = TServerUtils.updateSaslProcessor(serverType, processor);
        }
        TimedProcessor timedProcessor = new TimedProcessor(processor, context.getMetricsInfo());
        HostAndPort[] addresses = TServerUtils.getHostAndPorts(hostname, portHint);
        try {
            return TServerUtils.startTServer(serverType, timedProcessor, serverName, threadName, minThreads, threadTimeOut, config, timeBetweenThreadChecks, maxMessageSize, context.getServerSslParams(), context.getSaslParams(), context.getClientTimeoutInMillis(), backlog, portSearch, addresses);
        }
        catch (TTransportException e) {
            if (portSearch) {
                Map<Integer, Property> reservedPorts = TServerUtils.getReservedPorts(config, portHintProperty);
                HostAndPort last = addresses[addresses.length - 1];
                for (int port = last.getPort() + 1; port < last.getPort() + 1001; ++port) {
                    if (reservedPorts.containsKey(port)) {
                        log.debug("During port search, skipping reserved port {} - property {} ({})", new Object[]{port, reservedPorts.get(port).getKey(), reservedPorts.get(port).getDescription()});
                        continue;
                    }
                    if (PropertyType.PortRange.VALID_RANGE.isBefore((Object)port)) break;
                    try {
                        HostAndPort addr = HostAndPort.fromParts((String)hostname, (int)port);
                        return TServerUtils.startTServer(serverType, timedProcessor, serverName, threadName, minThreads, threadTimeOut, config, timeBetweenThreadChecks, maxMessageSize, context.getServerSslParams(), context.getSaslParams(), context.getClientTimeoutInMillis(), backlog, portSearch, addr);
                    }
                    catch (TTransportException tte) {
                        log.info("Unable to use port {}, retrying. (Thread Name = {})", (Object)port, (Object)threadName);
                    }
                }
                log.error("Unable to start TServer", (Throwable)e);
                throw new UnknownHostException("Unable to find a listen port");
            }
            log.error("Unable to start TServer", (Throwable)e);
            throw new UnknownHostException("Unable to find a listen port");
        }
    }

    private static ServerAddress createThreadedSelectorServer(HostAndPort address, TProcessor processor, TProtocolFactory protocolFactory, String serverName, int numThreads, long threadTimeOut, AccumuloConfiguration conf, long timeBetweenThreadChecks, long maxMessageSize, int backlog) throws TTransportException {
        TNonblockingServerSocket.NonblockingAbstractServerSocketArgs args = (TNonblockingServerSocket.NonblockingAbstractServerSocketArgs)((TNonblockingServerSocket.NonblockingAbstractServerSocketArgs)((TNonblockingServerSocket.NonblockingAbstractServerSocketArgs)((TNonblockingServerSocket.NonblockingAbstractServerSocketArgs)new TNonblockingServerSocket.NonblockingAbstractServerSocketArgs().backlog(backlog)).bindAddr(new InetSocketAddress(address.getHost(), address.getPort()))).clientTimeout(0)).maxFrameSize(Ints.saturatedCast((long)maxMessageSize));
        TNonblockingServerSocket transport = new TNonblockingServerSocket(args);
        TThreadedSelectorServer.Args options = new TThreadedSelectorServer.Args((TNonblockingServerTransport)transport);
        options.selectorThreads = Math.max(2, Runtime.getRuntime().availableProcessors() / 4);
        log.info("selectorThreads : " + options.selectorThreads);
        options.protocolFactory(protocolFactory);
        options.transportFactory(ThriftUtil.transportFactory((long)maxMessageSize));
        options.maxReadBufferBytes = maxMessageSize;
        options.stopTimeoutVal(5);
        ThreadPoolExecutor pool = TServerUtils.createSelfResizingThreadPool(serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks);
        options.executorService((ExecutorService)pool);
        options.processorFactory(new TProcessorFactory(processor));
        if (address.getPort() == 0) {
            address = HostAndPort.fromParts((String)address.getHost(), (int)transport.getPort());
        }
        return new ServerAddress((TServer)new CustomThreadedSelectorServer(options), address);
    }

    private static ServerAddress createNonBlockingServer(HostAndPort address, TProcessor processor, TProtocolFactory protocolFactory, String serverName, int numThreads, long threadTimeOut, AccumuloConfiguration conf, long timeBetweenThreadChecks, long maxMessageSize, int backlog) throws TTransportException {
        TNonblockingServerSocket.NonblockingAbstractServerSocketArgs args = (TNonblockingServerSocket.NonblockingAbstractServerSocketArgs)((TNonblockingServerSocket.NonblockingAbstractServerSocketArgs)((TNonblockingServerSocket.NonblockingAbstractServerSocketArgs)((TNonblockingServerSocket.NonblockingAbstractServerSocketArgs)new TNonblockingServerSocket.NonblockingAbstractServerSocketArgs().backlog(backlog)).bindAddr(new InetSocketAddress(address.getHost(), address.getPort()))).clientTimeout(0)).maxFrameSize(Ints.saturatedCast((long)maxMessageSize));
        TNonblockingServerSocket transport = new TNonblockingServerSocket(args);
        THsHaServer.Args options = new THsHaServer.Args((TNonblockingServerTransport)transport);
        options.protocolFactory(protocolFactory);
        options.transportFactory(ThriftUtil.transportFactory((long)maxMessageSize));
        options.maxReadBufferBytes = maxMessageSize;
        options.stopTimeoutVal(5);
        ThreadPoolExecutor pool = TServerUtils.createSelfResizingThreadPool(serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks);
        options.executorService((ExecutorService)pool);
        options.processorFactory(new TProcessorFactory(processor));
        if (address.getPort() == 0) {
            address = HostAndPort.fromParts((String)address.getHost(), (int)transport.getPort());
        }
        return new ServerAddress((TServer)new CustomNonBlockingServer(options), address);
    }

    private static ThreadPoolExecutor createSelfResizingThreadPool(String serverName, int executorThreads, long threadTimeOut, AccumuloConfiguration conf, long timeBetweenThreadChecks) {
        String poolName = ThreadPoolNames.ACCUMULO_POOL_PREFIX.poolName + "." + serverName.toLowerCase() + ".client";
        ThreadPoolExecutor pool = ThreadPools.getServerThreadPools().getPoolBuilder(poolName).numCoreThreads(executorThreads).withTimeOut(threadTimeOut, TimeUnit.MILLISECONDS).enableThreadPoolMetrics().build();
        ThreadPools.watchCriticalFixedDelay((AccumuloConfiguration)conf, (long)timeBetweenThreadChecks, () -> {
            if (pool.getCorePoolSize() <= pool.getActiveCount()) {
                int larger = pool.getCorePoolSize() + Math.min(pool.getQueue().size(), 2);
                ThreadPools.resizePool((ThreadPoolExecutor)pool, () -> larger, (String)poolName);
            } else if (pool.getCorePoolSize() > pool.getActiveCount() + 3) {
                int smaller = Math.max(executorThreads, pool.getCorePoolSize() - 1);
                ThreadPools.resizePool((ThreadPoolExecutor)pool, () -> smaller, (String)poolName);
            }
        });
        return pool;
    }

    private static ServerAddress createBlockingServer(HostAndPort address, TProcessor processor, TProtocolFactory protocolFactory, long maxMessageSize, String serverName, int numThreads, long threadTimeOut, AccumuloConfiguration conf, long timeBetweenThreadChecks, int backlog) throws TTransportException {
        InetSocketAddress isa = new InetSocketAddress(address.getHost(), address.getPort());
        TServerSocket.ServerSocketTransportArgs args = (TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)new TServerSocket.ServerSocketTransportArgs().backlog(backlog)).bindAddr(isa);
        TServerSocket transport = new TServerSocket(args);
        ThreadPoolExecutor pool = TServerUtils.createSelfResizingThreadPool(serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks);
        TThreadPoolServer server = TServerUtils.createTThreadPoolServer((TServerTransport)transport, processor, ThriftUtil.transportFactory((long)maxMessageSize), protocolFactory, pool);
        if (address.getPort() == 0) {
            address = HostAndPort.fromParts((String)address.getHost(), (int)transport.getServerSocket().getLocalPort());
            log.info("Blocking Server bound on {}", (Object)address);
        }
        return new ServerAddress((TServer)server, address);
    }

    private static TThreadPoolServer createTThreadPoolServer(TServerTransport transport, TProcessor processor, TTransportFactory transportFactory, TProtocolFactory protocolFactory, ExecutorService service) {
        TThreadPoolServer.Args options = new TThreadPoolServer.Args(transport);
        options.protocolFactory(protocolFactory);
        options.transportFactory(transportFactory);
        options.processorFactory((TProcessorFactory)new ClientInfoProcessorFactory(clientAddress, processor));
        if (service != null) {
            options.executorService(service);
        }
        return new TThreadPoolServer(options);
    }

    private static TServerSocket getSslServerSocket(int port, int timeout, InetAddress address, SslConnectionParams params) throws TTransportException {
        TServerSocket tServerSock = params.useJsse() ? TSSLTransportFactory.getServerSocket((int)port, (int)timeout, (boolean)params.isClientAuth(), (InetAddress)address) : TSSLTransportFactory.getServerSocket((int)port, (int)timeout, (InetAddress)address, (TSSLTransportFactory.TSSLTransportParameters)params.getTSSLTransportParameters());
        ServerSocket serverSock = tServerSock.getServerSocket();
        if (serverSock instanceof SSLServerSocket) {
            SSLServerSocket sslServerSock = (SSLServerSocket)serverSock;
            Object[] protocols = params.getServerProtocols();
            HashSet<String> socketEnabledProtocols = new HashSet<String>(Arrays.asList(sslServerSock.getEnabledProtocols()));
            socketEnabledProtocols.retainAll(Arrays.asList(protocols));
            if (socketEnabledProtocols.isEmpty()) {
                throw new RuntimeException("No available protocols available for secure socket. Available protocols: " + Arrays.toString(sslServerSock.getEnabledProtocols()) + ", allowed protocols: " + Arrays.toString(protocols));
            }
            sslServerSock.setEnabledProtocols(socketEnabledProtocols.toArray(new String[0]));
        }
        return tServerSock;
    }

    private static ServerAddress createSslThreadPoolServer(HostAndPort address, TProcessor processor, TProtocolFactory protocolFactory, long socketTimeout, SslConnectionParams sslParams, String serverName, int numThreads, long threadTimeOut, AccumuloConfiguration conf, long timeBetweenThreadChecks) throws TTransportException {
        TServerSocket transport;
        try {
            transport = TServerUtils.getSslServerSocket(address.getPort(), (int)socketTimeout, InetAddress.getByName(address.getHost()), sslParams);
        }
        catch (UnknownHostException e) {
            throw new TTransportException((Throwable)e);
        }
        if (address.getPort() == 0) {
            address = HostAndPort.fromParts((String)address.getHost(), (int)transport.getServerSocket().getLocalPort());
            log.info("SSL Thread Pool Server bound on {}", (Object)address);
        }
        ThreadPoolExecutor pool = TServerUtils.createSelfResizingThreadPool(serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks);
        return new ServerAddress((TServer)TServerUtils.createTThreadPoolServer((TServerTransport)transport, processor, ThriftUtil.transportFactory(), protocolFactory, pool), address);
    }

    private static ServerAddress createSaslThreadPoolServer(HostAndPort address, TProcessor processor, TProtocolFactory protocolFactory, long socketTimeout, SaslServerConnectionParams params, String serverName, int numThreads, long threadTimeOut, AccumuloConfiguration conf, long timeBetweenThreadChecks, int backlog) throws TTransportException {
        UserGroupInformation serverUser;
        String fqdn;
        String hostname;
        log.info("Creating SASL thread pool thrift server on listening on {}:{}", (Object)address.getHost(), (Object)address.getPort());
        InetSocketAddress isa = new InetSocketAddress(address.getHost(), address.getPort());
        TServerSocket.ServerSocketTransportArgs args = (TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)((TServerSocket.ServerSocketTransportArgs)new TServerSocket.ServerSocketTransportArgs().backlog(backlog)).bindAddr(isa)).clientTimeout((int)socketTimeout);
        TServerSocket transport = new TServerSocket(args);
        try {
            hostname = InetAddress.getByName(address.getHost()).getCanonicalHostName();
            fqdn = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            transport.close();
            throw new TTransportException((Throwable)e);
        }
        if ("0.0.0.0".equals(hostname)) {
            hostname = fqdn;
        }
        if (!hostname.equals(fqdn)) {
            log.error("Expected hostname of '{}' but got '{}'. Ensure the entries in the Accumulo hosts files (e.g. managers, tservers) are the FQDN for each host when using SASL.", (Object)fqdn, (Object)hostname);
            transport.close();
            throw new RuntimeException("SASL requires that the address the thrift server listens on is the same as the FQDN for this host");
        }
        try {
            serverUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            transport.close();
            ThriftUtil.checkIOExceptionCause((IOException)e);
            throw new TTransportException((Throwable)e);
        }
        log.debug("Logged in as {}, creating TSaslServerTransport factory with {}/{}", new Object[]{serverUser, params.getKerberosServerPrimary(), hostname});
        TSaslServerTransport.Factory saslTransportFactory = new TSaslServerTransport.Factory();
        saslTransportFactory.addServerDefinition("GSSAPI", params.getKerberosServerPrimary(), hostname, params.getSaslProperties(), (CallbackHandler)new SaslRpcServer.SaslGssCallbackHandler());
        if (params.getSecretManager() != null) {
            log.info("Adding DIGEST-MD5 server definition for delegation tokens");
            saslTransportFactory.addServerDefinition("DIGEST-MD5", params.getKerberosServerPrimary(), hostname, params.getSaslProperties(), (CallbackHandler)((Object)new SaslServerDigestCallbackHandler(params.getSecretManager())));
        } else {
            log.info("SecretManager is null, not adding support for delegation token authentication");
        }
        UGIAssumingTransportFactory ugiTransportFactory = new UGIAssumingTransportFactory((TTransportFactory)saslTransportFactory, serverUser);
        if (address.getPort() == 0) {
            address = HostAndPort.fromParts((String)address.getHost(), (int)transport.getServerSocket().getLocalPort());
            log.info("SASL thrift server bound on {}", (Object)address);
        }
        ThreadPoolExecutor pool = TServerUtils.createSelfResizingThreadPool(serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks);
        TThreadPoolServer server = TServerUtils.createTThreadPoolServer((TServerTransport)transport, processor, (TTransportFactory)ugiTransportFactory, protocolFactory, pool);
        return new ServerAddress((TServer)server, address);
    }

    public static ServerAddress startTServer(AccumuloConfiguration conf, ThriftServerType serverType, TProcessor processor, String serverName, String threadName, int numThreads, long threadTimeOut, long timeBetweenThreadChecks, long maxMessageSize, SslConnectionParams sslParams, SaslServerConnectionParams saslParams, long serverSocketTimeout, int backlog, MetricsInfo metricsInfo, boolean portSearch, HostAndPort ... addresses) {
        if (serverType == ThriftServerType.SASL) {
            processor = TServerUtils.updateSaslProcessor(serverType, processor);
        }
        try {
            return TServerUtils.startTServer(serverType, new TimedProcessor(processor, metricsInfo), serverName, threadName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks, maxMessageSize, sslParams, saslParams, serverSocketTimeout, backlog, portSearch, addresses);
        }
        catch (TTransportException e) {
            throw new IllegalStateException(e);
        }
    }

    private static ServerAddress startTServer(ThriftServerType serverType, TimedProcessor processor, String serverName, String threadName, int numThreads, long threadTimeOut, AccumuloConfiguration conf, long timeBetweenThreadChecks, long maxMessageSize, SslConnectionParams sslParams, SaslServerConnectionParams saslParams, long serverSocketTimeout, int backlog, boolean portSearch, HostAndPort ... addresses) throws TTransportException {
        TProtocolFactory protocolFactory = ThriftUtil.protocolFactory();
        Preconditions.checkArgument((sslParams == null || saslParams == null ? 1 : 0) != 0, (Object)"Cannot start a Thrift server using both SSL and SASL");
        ServerAddress serverAddress = null;
        for (HostAndPort address : addresses) {
            try {
                switch (serverType) {
                    case SSL: {
                        log.debug("Instantiating SSL Thrift server");
                        serverAddress = TServerUtils.createSslThreadPoolServer(address, processor, protocolFactory, serverSocketTimeout, sslParams, serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks);
                        break;
                    }
                    case SASL: {
                        log.debug("Instantiating SASL Thrift server");
                        serverAddress = TServerUtils.createSaslThreadPoolServer(address, processor, protocolFactory, serverSocketTimeout, saslParams, serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks, backlog);
                        break;
                    }
                    case THREADPOOL: {
                        log.debug("Instantiating unsecure TThreadPool Thrift server");
                        serverAddress = TServerUtils.createBlockingServer(address, processor, protocolFactory, maxMessageSize, serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks, backlog);
                        break;
                    }
                    case THREADED_SELECTOR: {
                        log.debug("Instantiating default, unsecure Threaded selector Thrift server");
                        serverAddress = TServerUtils.createThreadedSelectorServer(address, processor, protocolFactory, serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks, maxMessageSize, backlog);
                        break;
                    }
                    case CUSTOM_HS_HA: {
                        log.debug("Instantiating unsecure custom half-async Thrift server");
                        serverAddress = TServerUtils.createNonBlockingServer(address, processor, protocolFactory, serverName, numThreads, threadTimeOut, conf, timeBetweenThreadChecks, maxMessageSize, backlog);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown server type " + String.valueOf((Object)serverType));
                    }
                }
                break;
            }
            catch (TTransportException e) {
                if (portSearch) {
                    log.debug("Failed attempting to create server at {}. {}", (Object)address, (Object)e.getMessage());
                    continue;
                }
                log.warn("Error attempting to create server at {}. Error: {}", (Object)address, (Object)e.getMessage());
            }
        }
        if (serverAddress == null) {
            throw new TTransportException("Unable to create server on addresses: " + Arrays.toString(addresses));
        }
        TServer finalServer = serverAddress.server;
        Threads.createCriticalThread((String)threadName, () -> ((TServer)finalServer).serve()).start();
        while (!finalServer.isServing()) {
            UtilWaitThread.sleep((long)10L);
            Preconditions.checkState((!finalServer.getShouldStop() ? 1 : 0) != 0);
        }
        if (serverAddress.address.getHost().equals("0.0.0.0")) {
            try {
                serverAddress = new ServerAddress(finalServer, HostAndPort.fromParts((String)InetAddress.getLocalHost().getHostName(), (int)serverAddress.address.getPort()));
            }
            catch (UnknownHostException e) {
                throw new TTransportException((Throwable)e);
            }
        }
        return serverAddress;
    }

    private static TProcessor updateSaslProcessor(ThriftServerType serverType, TProcessor processor) {
        Preconditions.checkArgument((serverType == ThriftServerType.SASL ? 1 : 0) != 0);
        log.info("Wrapping {} in UGIAssumingProcessor", processor.getClass());
        return new UGIAssumingProcessor(processor);
    }
}

