/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util.fateCommand;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.accumulo.core.fate.AdminUtil;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.server.util.fateCommand.FateTxnDetails;

public class FateSummaryReport {
    private final Map<String, Integer> statusCounts = new TreeMap<String, Integer>();
    private final Map<String, Integer> cmdCounts = new TreeMap<String, Integer>();
    private final Map<String, Integer> stepCounts = new TreeMap<String, Integer>();
    private final Set<FateTxnDetails> fateDetails = new TreeSet<FateTxnDetails>();
    private final long reportTime = Instant.now().toEpochMilli();
    private final Set<String> statusFilterNames = new TreeSet<String>();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final transient Map<String, String> idsToNameMap;

    public FateSummaryReport(Map<String, String> idsToNameMap, EnumSet<ReadOnlyTStore.TStatus> statusFilter) {
        this.idsToNameMap = idsToNameMap;
        if (statusFilter != null) {
            statusFilter.forEach(f -> this.statusFilterNames.add(f.name()));
        }
    }

    public void gatherTxnStatus(AdminUtil.TransactionStatus txnStatus) {
        ReadOnlyTStore.TStatus status = txnStatus.getStatus();
        if (status == null) {
            this.statusCounts.merge("?", 1, Integer::sum);
        } else {
            String name = txnStatus.getStatus().name();
            this.statusCounts.merge(name, 1, Integer::sum);
        }
        String top = txnStatus.getTop();
        this.stepCounts.merge(Objects.requireNonNullElse(top, "?"), 1, Integer::sum);
        String runningRepo = txnStatus.getTxName();
        this.cmdCounts.merge(Objects.requireNonNullElse(runningRepo, "?"), 1, Integer::sum);
        if (!this.statusFilterNames.isEmpty() && !this.statusFilterNames.contains(txnStatus.getStatus().name())) {
            return;
        }
        this.fateDetails.add(new FateTxnDetails(this.reportTime, txnStatus, this.idsToNameMap));
    }

    public Map<String, Integer> getStatusCounts() {
        return this.statusCounts;
    }

    public Map<String, Integer> getCmdCounts() {
        return this.cmdCounts;
    }

    public Map<String, Integer> getStepCounts() {
        return this.stepCounts;
    }

    public Set<FateTxnDetails> getFateDetails() {
        return this.fateDetails;
    }

    public long getReportTime() {
        return this.reportTime;
    }

    public Set<String> getStatusFilterNames() {
        return this.statusFilterNames;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static FateSummaryReport fromJson(String jsonString) {
        return (FateSummaryReport)gson.fromJson(jsonString, FateSummaryReport.class);
    }

    public List<String> formatLines() {
        ArrayList<String> lines = new ArrayList<String>();
        DateTimeFormatter fmt = DateTimeFormatter.ISO_INSTANT.withZone(ZoneId.from(ZoneOffset.UTC));
        lines.add(String.format("Report Time: %s", fmt.format(Instant.ofEpochMilli(this.reportTime).truncatedTo(ChronoUnit.SECONDS))));
        lines.add("Status counts:");
        this.statusCounts.forEach((status, count) -> lines.add(String.format("  %s: %d", status, count)));
        lines.add("Command counts:");
        this.cmdCounts.forEach((cmd, count) -> lines.add(String.format("  %s: %d", cmd, count)));
        lines.add("Step counts:");
        this.stepCounts.forEach((step, count) -> lines.add(String.format("  %s: %d", step, count)));
        lines.add("\nFate transactions (oldest first):");
        lines.add("Status Filters: " + (this.statusFilterNames.isEmpty() ? "[NONE]" : this.statusFilterNames.toString()));
        lines.add("Running\ttxn_id\t\t\t\tStatus\t\tCommand\t\tStep (top)\t\tlocks held:(table id, name)\tlocks waiting:(table id, name)");
        this.fateDetails.forEach(txnDetails -> lines.add(txnDetails.toString()));
        return lines;
    }
}

