/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.bulkImports;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.BulkImportStatus;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.bulkImports.BulkImport;
import org.apache.accumulo.monitor.rest.bulkImports.BulkImportInformation;
import org.apache.accumulo.monitor.rest.bulkImports.TabletServerBulkImportInformation;

@Path(value="/bulkImports")
@Produces(value={"application/json", "application/xml"})
public class BulkImportResource {
    @Inject
    private Monitor monitor;

    @GET
    public BulkImport getTables() {
        BulkImport bulkImport = new BulkImport();
        ManagerMonitorInfo mmi = this.monitor.getMmi();
        if (mmi == null) {
            return bulkImport;
        }
        for (BulkImportStatus bulk : mmi.bulkImports) {
            bulkImport.addBulkImport(new BulkImportInformation(bulk.filename, bulk.startTime, bulk.state));
        }
        for (TabletServerStatus tserverInfo : mmi.getTServerInfo()) {
            int size = 0;
            long oldest = 0L;
            List stats = tserverInfo.bulkImports;
            if (stats != null) {
                size = stats.size();
                oldest = Long.MAX_VALUE;
                for (BulkImportStatus bulk : stats) {
                    oldest = Math.min(oldest, bulk.startTime);
                }
                if (oldest == Long.MAX_VALUE) {
                    oldest = 0L;
                }
            }
            bulkImport.addTabletServerBulkImport(new TabletServerBulkImportInformation(tserverInfo, size, oldest));
        }
        return bulkImport;
    }
}

