/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.scans;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.scans.ScanInformation;
import org.apache.accumulo.monitor.rest.scans.Scans;

@Path(value="/scans")
@Produces(value={"application/json", "application/xml"})
public class ScansResource {
    @Inject
    private Monitor monitor;

    @GET
    public Scans getActiveScans() throws Exception {
        Scans scans = new Scans();
        ManagerMonitorInfo mmi = this.monitor.getMmi();
        if (mmi == null) {
            return scans;
        }
        Map<HostAndPort, Monitor.ScanStats> entry = this.monitor.getScans();
        for (TabletServerStatus tserverInfo : mmi.getTServerInfo()) {
            Monitor.ScanStats stats = entry.get(HostAndPort.fromString((String)tserverInfo.name));
            if (stats == null) continue;
            scans.addScan(new ScanInformation(tserverInfo.name, stats));
        }
        this.monitor.getScanServerScans().forEach((k, v) -> scans.addScan(new ScanInformation(k.toString(), (Monitor.ScanStats)v)));
        return scans;
    }
}

