/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.lang.ref.Cleaner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletServerBatchWriter;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.util.cleaner.CleanerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableBatchWriterImpl
implements MultiTableBatchWriter {
    private static final Logger log = LoggerFactory.getLogger(MultiTableBatchWriterImpl.class);
    private final ConcurrentHashMap<TableId, BatchWriter> tableWriters = new ConcurrentHashMap();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ClientContext context;
    private final TabletServerBatchWriter bw;
    private final Cleaner.Cleanable cleanable;

    MultiTableBatchWriterImpl(ClientContext context, BatchWriterConfig config) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config is null");
        this.context = context;
        this.bw = new TabletServerBatchWriter(context, config);
        this.cleanable = CleanerUtil.unclosed(this, MultiTableBatchWriter.class, this.closed, log, this.bw);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() throws MutationsRejectedException {
        if (this.closed.compareAndSet(false, true)) {
            this.cleanable.clean();
            this.bw.close();
        }
    }

    @Override
    public BatchWriter getBatchWriter(String tableName) throws TableNotFoundException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        TableId tableId = this.context.getTableId(tableName);
        BatchWriter tbw = this.tableWriters.get(tableId);
        if (tbw == null) {
            tbw = new TableBatchWriter(tableId);
            BatchWriter current = this.tableWriters.putIfAbsent(tableId, tbw);
            return current != null ? current : tbw;
        }
        return tbw;
    }

    @Override
    public void flush() throws MutationsRejectedException {
        this.bw.flush();
    }

    private class TableBatchWriter
    implements BatchWriter {
        private final TableId tableId;

        private TableBatchWriter(TableId tableId) {
            this.tableId = tableId;
        }

        @Override
        public void addMutation(Mutation m) throws MutationsRejectedException {
            Preconditions.checkArgument((m != null ? 1 : 0) != 0, (Object)"m is null");
            MultiTableBatchWriterImpl.this.bw.addMutation(this.tableId, m);
        }

        @Override
        public void addMutations(Iterable<Mutation> iterable) throws MutationsRejectedException {
            MultiTableBatchWriterImpl.this.bw.addMutation(this.tableId, iterable.iterator());
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("Must close all tables, can not close an individual table");
        }

        @Override
        public void flush() {
            throw new UnsupportedOperationException("Must flush all tables, can not flush an individual table");
        }
    }
}

