/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.rpc.SaslConnectionParams;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.util.HostAndPort;

@VisibleForTesting
public class ThriftTransportKey {
    private final ThriftClientTypes<?> type;
    private final HostAndPort server;
    private final long timeout;
    private final SslConnectionParams sslParams;
    private final SaslConnectionParams saslParams;
    private final int hash;

    @VisibleForTesting
    public ThriftTransportKey(ThriftClientTypes<?> type, HostAndPort server, long timeout, ClientContext context) {
        this(type, server, timeout, context.getClientSslParams(), context.getSaslParams());
    }

    ThriftTransportKey(ThriftClientTypes<?> type, HostAndPort server, long timeout, SslConnectionParams sslParams, SaslConnectionParams saslParams) {
        Objects.requireNonNull(server, "location is null");
        this.type = type;
        this.server = server;
        this.timeout = timeout;
        this.sslParams = sslParams;
        this.saslParams = saslParams;
        if (saslParams != null && sslParams != null) {
            throw new RuntimeException("Cannot use both SSL and SASL thrift transports");
        }
        this.hash = Objects.hash(type, server, timeout, sslParams, saslParams);
    }

    @VisibleForTesting
    public ThriftClientTypes<?> getType() {
        return this.type;
    }

    @VisibleForTesting
    public HostAndPort getServer() {
        return this.server;
    }

    @VisibleForTesting
    public long getTimeout() {
        return this.timeout;
    }

    public boolean isSsl() {
        return this.sslParams != null;
    }

    public boolean isSasl() {
        return this.saslParams != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ThriftTransportKey)) {
            return false;
        }
        ThriftTransportKey ttk = (ThriftTransportKey)o;
        return this.type.equals(ttk.type) && this.server.equals(ttk.server) && this.timeout == ttk.timeout && (!this.isSsl() || ttk.isSsl() && this.sslParams.equals(ttk.sslParams)) && (!this.isSasl() || ttk.isSasl() && this.saslParams.equals(ttk.saslParams));
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        Object prefix = "";
        if (this.isSsl()) {
            prefix = "ssl:";
        } else if (this.isSasl()) {
            prefix = String.valueOf(this.saslParams) + ":";
        }
        return (String)prefix + String.valueOf(this.type) + ":" + String.valueOf(this.server) + " (" + this.timeout + ")";
    }

    public SslConnectionParams getSslParams() {
        return this.sslParams;
    }

    public SaslConnectionParams getSaslParams() {
        return this.saslParams;
    }
}

