/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.ServerWrappingIterator;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public abstract class ServerFilter
extends ServerWrappingIterator {
    public ServerFilter(SortedKeyValueIterator<Key, Value> source) {
        super(source);
    }

    @Override
    public abstract SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment var1);

    @Override
    public void next() throws IOException {
        this.source.next();
        this.findTop();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.source.seek(range, columnFamilies, inclusive);
        this.findTop();
    }

    private void findTop() throws IOException {
        Key top;
        while (this.source.hasTop() && !(top = (Key)this.source.getTopKey()).isDeleted() && !this.accept(top, (Value)this.source.getTopValue())) {
            this.source.next();
        }
    }

    public abstract boolean accept(Key var1, Value var2);

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }
}

