/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class ColumnSliceFilter
extends Filter {
    public static final String START_BOUND = "startBound";
    public static final String START_INCLUSIVE = "startInclusive";
    public static final String END_BOUND = "endBound";
    public static final String END_INCLUSIVE = "endInclusive";
    private String startBound;
    private String endBound;
    private boolean startInclusive;
    private boolean endInclusive;

    @Override
    public boolean accept(Key key, Value value) {
        String colQ = key.getColumnQualifier().toString();
        return (this.startBound == null || (this.startInclusive ? colQ.compareTo(this.startBound) >= 0 : colQ.compareTo(this.startBound) > 0)) && (this.endBound == null || (this.endInclusive ? colQ.compareTo(this.endBound) <= 0 : colQ.compareTo(this.endBound) < 0));
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.startBound = options.getOrDefault(START_BOUND, null);
        this.startInclusive = options.containsKey(START_INCLUSIVE) ? Boolean.parseBoolean(options.get(START_INCLUSIVE)) : true;
        this.endBound = options.getOrDefault(END_BOUND, null);
        this.endInclusive = options.containsKey(END_INCLUSIVE) ? Boolean.parseBoolean(options.get(END_INCLUSIVE)) : false;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        OptionDescriber.IteratorOptions io = super.describeOptions();
        io.setName("columnSlice");
        io.setDescription("The ColumnSliceFilter/Iterator allows you to filter for key/value pairs based on a lexicographic range of column qualifier names");
        io.addNamedOption(START_BOUND, "start string in slice");
        io.addNamedOption(END_BOUND, "end string in slice");
        io.addNamedOption(START_INCLUSIVE, "include the start bound in the result set");
        io.addNamedOption(END_INCLUSIVE, "include the end bound in the result set");
        return io;
    }

    public static void setSlice(IteratorSetting si, String start, String end) {
        ColumnSliceFilter.setSlice(si, start, true, end, false);
    }

    public static void setSlice(IteratorSetting si, String start, boolean startInclusive, String end, boolean endInclusive) {
        if (!(start == null || end == null || start.compareTo(end) <= 0 && (start.compareTo(end) != 0 || startInclusive && endInclusive))) {
            throw new IllegalArgumentException("Start key must be less than end key or equal with both sides inclusive in range (" + start + ", " + end + ")");
        }
        if (start != null) {
            si.addOption(START_BOUND, start);
        }
        if (end != null) {
            si.addOption(END_BOUND, end);
        }
        si.addOption(START_INCLUSIVE, String.valueOf(startInclusive));
        si.addOption(END_INCLUSIVE, String.valueOf(endInclusive));
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        ColumnSliceFilter result = (ColumnSliceFilter)super.deepCopy(env);
        result.startBound = this.startBound;
        result.startInclusive = this.startInclusive;
        result.endBound = this.endBound;
        result.endInclusive = this.endInclusive;
        return result;
    }
}

