/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.security;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;

public enum NamespacePermission {
    READ(0),
    WRITE(1),
    ALTER_NAMESPACE(2),
    GRANT(3),
    ALTER_TABLE(4),
    CREATE_TABLE(5),
    DROP_TABLE(6),
    BULK_IMPORT(7),
    DROP_NAMESPACE(8);

    private final byte permID;
    private static final NamespacePermission[] mapping;

    private NamespacePermission(byte id) {
        this.permID = id;
    }

    public byte getId() {
        return this.permID;
    }

    public static List<String> printableValues() {
        NamespacePermission[] a = NamespacePermission.values();
        ArrayList<String> list = new ArrayList<String>(a.length);
        for (NamespacePermission p : a) {
            list.add("Namespace." + String.valueOf((Object)p));
        }
        return list;
    }

    public static NamespacePermission getPermissionById(byte id) {
        NamespacePermission result = mapping[id];
        if (result != null) {
            return result;
        }
        throw new IndexOutOfBoundsException("No such permission");
    }

    public static NamespacePermission getEquivalent(TablePermission permission) {
        switch (permission) {
            case READ: {
                return READ;
            }
            case WRITE: {
                return WRITE;
            }
            case ALTER_TABLE: {
                return ALTER_TABLE;
            }
            case GRANT: {
                return GRANT;
            }
            case DROP_TABLE: {
                return DROP_TABLE;
            }
            case BULK_IMPORT: {
                return BULK_IMPORT;
            }
        }
        return null;
    }

    public static NamespacePermission getEquivalent(SystemPermission permission) {
        switch (permission) {
            case CREATE_TABLE: {
                return CREATE_TABLE;
            }
            case DROP_TABLE: {
                return DROP_TABLE;
            }
            case ALTER_TABLE: {
                return ALTER_TABLE;
            }
            case ALTER_NAMESPACE: {
                return ALTER_NAMESPACE;
            }
            case DROP_NAMESPACE: {
                return DROP_NAMESPACE;
            }
            case GRANT: {
                return ALTER_NAMESPACE;
            }
        }
        return null;
    }

    static {
        mapping = new NamespacePermission[9];
        NamespacePermission[] namespacePermissionArray = NamespacePermission.values();
        int n = namespacePermissionArray.length;
        for (int i = 0; i < n; ++i) {
            NamespacePermission perm;
            NamespacePermission.mapping[perm.permID] = perm = namespacePermissionArray[i];
        }
    }
}

