/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.balancer;

import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.spi.balancer.BalancerEnvironment;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoNothingBalancer
implements TabletBalancer {
    private static final Logger log = LoggerFactory.getLogger(DoNothingBalancer.class);
    private final TableId tableId;

    public DoNothingBalancer() {
        this.tableId = null;
    }

    public DoNothingBalancer(TableId tableId) {
        this.tableId = tableId;
    }

    @Override
    public void init(BalancerEnvironment balancerEnvironment) {
    }

    @Override
    public void getAssignments(TabletBalancer.AssignmentParameters params) {
        if (this.tableId != null) {
            log.warn("Balancer creation failed. Ignoring {} assignment request for tableId {}", (Object)params.unassignedTablets().size(), (Object)this.tableId);
        } else {
            log.warn("Balancer creation failed. Ignoring {} assignment request ", (Object)params.unassignedTablets().size());
        }
    }

    @Override
    public long balance(TabletBalancer.BalanceParameters params) {
        if (this.tableId != null) {
            log.warn("Balancer creation failed. Ignoring request to balance tablets for tableId:{}", (Object)this.tableId);
        } else {
            log.warn("Balancer creation failed. Ignoring request to balance tablets");
        }
        return 30000L;
    }
}

