/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.logging.LoggingMeterRegistry;
import io.micrometer.core.instrument.logging.LoggingRegistryConfig;
import java.util.HashMap;
import java.util.function.Consumer;
import org.apache.accumulo.core.spi.metrics.MeterRegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMeterRegistryFactory
implements MeterRegistryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingMeterRegistryFactory.class);
    private static final Logger METRICS = LoggerFactory.getLogger((String)"org.apache.accumulo.METRICS");

    @Override
    public MeterRegistry create(MeterRegistryFactory.InitParameters params) {
        Consumer<String> metricConsumer = arg_0 -> ((Logger)METRICS).info(arg_0);
        HashMap<String, String> metricsProps = new HashMap<String, String>();
        LoggingRegistryConfig lconf = c -> {
            if (c.equals("logging.step")) {
                return metricsProps.getOrDefault("logging.step", "60s");
            }
            return null;
        };
        LOG.info("Creating logging metrics registry with params: {}", (Object)params);
        metricsProps.putAll(params.getOptions());
        return LoggingMeterRegistry.builder((LoggingRegistryConfig)lconf).loggingSink(metricConsumer).build();
    }
}

