/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.server.metrics.NoopMetrics;

public class TabletServerUpdateMetrics
implements MetricsProducer {
    private Counter permissionErrorsCounter = NoopMetrics.useNoopCounter();
    private Counter unknownTabletErrorsCounter = NoopMetrics.useNoopCounter();
    private Counter constraintViolationsCounter = NoopMetrics.useNoopCounter();
    private Timer commitPrepStat = NoopMetrics.useNoopTimer();
    private Timer walogWriteTimeStat = NoopMetrics.useNoopTimer();
    private Timer commitTimeStat = NoopMetrics.useNoopTimer();
    private DistributionSummary mutationArraySizeStat = NoopMetrics.useNoopDistributionSummary();

    public void addPermissionErrors(long value) {
        this.permissionErrorsCounter.increment((double)value);
    }

    public void addUnknownTabletErrors(long value) {
        this.unknownTabletErrorsCounter.increment((double)value);
    }

    public void addConstraintViolations(long value) {
        this.constraintViolationsCounter.increment((double)value);
    }

    public void addCommitPrep(long value) {
        this.commitPrepStat.record(Duration.ofMillis(value));
    }

    public void addWalogWriteTime(long value) {
        this.walogWriteTimeStat.record(Duration.ofMillis(value));
    }

    public void addCommitTime(long value) {
        this.commitTimeStat.record(Duration.ofMillis(value));
    }

    public void addMutationArraySize(long value) {
        this.mutationArraySizeStat.record((double)value);
    }

    public void registerMetrics(MeterRegistry registry) {
        this.permissionErrorsCounter = registry.counter("accumulo.tserver.updates.error", new String[]{"type", "permission"});
        this.unknownTabletErrorsCounter = registry.counter("accumulo.tserver.updates.error", new String[]{"type", "unknown.tablet"});
        this.constraintViolationsCounter = registry.counter("accumulo.tserver.updates.error", new String[]{"type", "constraint.violation"});
        this.commitPrepStat = Timer.builder((String)"accumulo.tserver.updates.commit.prep").description("preparing to commit mutations").register(registry);
        this.walogWriteTimeStat = Timer.builder((String)"accumulo.tserver.updates.walog.write").description("writing mutations to WAL").register(registry);
        this.commitTimeStat = Timer.builder((String)"accumulo.tserver.updates.commit").description("committing mutations").register(registry);
        this.mutationArraySizeStat = DistributionSummary.builder((String)"accumulo.tserver.updates.mutation.arrays.size").description("mutation array").register(registry);
    }
}

