/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.scan;

import com.google.common.base.Preconditions;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.tserver.TabletHostingServer;
import org.apache.accumulo.tserver.scan.ScanRunState;

public abstract class ScanTask<T>
implements Runnable {
    protected final TabletHostingServer server;
    protected AtomicBoolean interruptFlag;
    protected ArrayBlockingQueue<Object> resultQueue;
    protected AtomicInteger state;
    private AtomicReference<ScanRunState> runState;
    private Thread scanThread = null;
    private final Lock scanThreadLock = new ReentrantLock();
    private static final int INITIAL = 1;
    private static final int ADDED = 2;
    private static final int CANCELED = 3;

    ScanTask(TabletHostingServer server) {
        this.server = server;
        this.interruptFlag = new AtomicBoolean(false);
        this.runState = new AtomicReference<ScanRunState>(ScanRunState.QUEUED);
        this.state = new AtomicInteger(1);
        this.resultQueue = new ArrayBlockingQueue(1);
    }

    protected boolean transitionToRunning() {
        if (this.runState.compareAndSet(ScanRunState.QUEUED, ScanRunState.RUNNING)) {
            this.scanThreadLock.lock();
            try {
                Preconditions.checkState((this.scanThread == null ? 1 : 0) != 0);
                this.scanThread = Thread.currentThread();
            }
            finally {
                this.scanThreadLock.unlock();
            }
            return true;
        }
        return false;
    }

    protected void transitionFromRunning() {
        this.scanThreadLock.lock();
        try {
            Preconditions.checkState((this.scanThread != null ? 1 : 0) != 0);
            this.scanThread = null;
        }
        finally {
            this.scanThreadLock.unlock();
        }
        this.runState.compareAndSet(ScanRunState.RUNNING, ScanRunState.FINISHED);
    }

    public ScanThreadStackTrace getStackTrace() {
        this.scanThreadLock.lock();
        try {
            if (this.scanThread == null) {
                ScanThreadStackTrace scanThreadStackTrace = null;
                return scanThreadStackTrace;
            }
            ScanThreadStackTrace scanThreadStackTrace = new ScanThreadStackTrace(this.scanThread);
            return scanThreadStackTrace;
        }
        finally {
            this.scanThreadLock.unlock();
        }
    }

    protected void addResult(Object o) {
        if (this.state.compareAndSet(1, 2)) {
            this.resultQueue.add(o);
        } else if (this.state.get() == 2) {
            throw new IllegalStateException("Tried to add more than one result");
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!mayInterruptIfRunning) {
            throw new IllegalArgumentException("Cancel will always attempt to interrupt running next batch task");
        }
        if (this.state.compareAndSet(1, 3)) {
            this.interruptFlag.set(true);
            this.resultQueue = null;
            return true;
        }
        if (this.state.get() == 3) {
            this.scanThreadLock.lock();
            try {
                if (this.scanThread != null) {
                    this.scanThread.interrupt();
                }
            }
            finally {
                this.scanThreadLock.unlock();
            }
            return true;
        }
        return false;
    }

    private String stateString(int state) {
        String stateStr;
        switch (state) {
            case 2: {
                stateStr = "ADDED";
                break;
            }
            case 3: {
                stateStr = "CANCELED";
                break;
            }
            case 1: {
                stateStr = "INITIAL";
                break;
            }
            default: {
                stateStr = "UNKNOWN";
            }
        }
        return stateStr;
    }

    public T get(long busyTimeout, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Object r;
        ArrayBlockingQueue<Object> localRQ = this.resultQueue;
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (localRQ == null) {
            int st = this.state.get();
            throw new IllegalStateException("Tried to get result twice [state=" + this.stateString(st) + "(" + st + ")]");
        }
        if (busyTimeout > 0L && this.runState.get() == ScanRunState.QUEUED) {
            r = localRQ.poll(busyTimeout, unit);
            if (r == null) {
                if (this.runState.compareAndSet(ScanRunState.QUEUED, ScanRunState.FINISHED)) {
                    this.state.compareAndSet(1, 3);
                    if (this.state.get() != 3) {
                        throw new IllegalStateException("Scan task is in unexpected state " + this.stateString(this.state.get()));
                    }
                } else {
                    long waitTime = Math.max(0L, timeout - busyTimeout);
                    r = localRQ.poll(waitTime, unit);
                }
            }
        } else {
            r = localRQ.poll(timeout, unit);
        }
        if (this.isCancelled()) {
            if (r != null) {
                throw new IllegalStateException("Nothing should have been added when in canceled state");
            }
            throw new CancellationException();
        }
        if (r == null) {
            throw new TimeoutException();
        }
        this.resultQueue = null;
        if (r instanceof Throwable) {
            throw new ExecutionException((Throwable)r);
        }
        Object rAsT = r;
        return (T)rAsT;
    }

    public boolean isCancelled() {
        return this.state.get() == 3;
    }

    public boolean producedResult() {
        return this.state.get() == 2;
    }

    public ScanRunState getScanRunState() {
        return this.runState.get();
    }

    public Thread getScanThread() {
        this.scanThreadLock.lock();
        try {
            Thread thread = this.scanThread;
            return thread;
        }
        finally {
            this.scanThreadLock.unlock();
        }
    }

    public static class ScanThreadStackTrace {
        public final long threadId;
        public final String threadName;
        public final StackTraceElement[] stackTrace;

        private ScanThreadStackTrace(Thread thread) {
            this.threadId = thread.getId();
            this.stackTrace = thread.getStackTrace();
            this.threadName = thread.getName();
        }
    }
}

