/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ExecfileCommand
extends Shell.Command {
    private Option verboseOption;

    @Override
    public String description() {
        return "specifies a file containing accumulo commands to execute";
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="app is run in same security context as user providing the filename")
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        try (Scanner scanner = new Scanner(new File(cl.getArgs()[0]), StandardCharsets.UTF_8);){
            while (scanner.hasNextLine()) {
                shellState.execCommand(scanner.nextLine(), true, cl.hasOption(this.verboseOption.getOpt()));
            }
        }
        return 0;
    }

    @Override
    public String usage() {
        return this.getName() + " <fileName>";
    }

    @Override
    public int numArgs() {
        return 1;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        this.verboseOption = new Option("v", "verbose", false, "display command prompt as commands are executed");
        opts.addOption(this.verboseOption);
        return opts;
    }
}

