/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoop.mapreduce;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.hadoop.mapreduce.InputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapreduce.AccumuloRecordReader;
import org.apache.accumulo.hadoopImpl.mapreduce.InputFormatBuilderImpl;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloInputFormat
extends InputFormat<Key, Value> {
    private static final Class<AccumuloInputFormat> CLASS = AccumuloInputFormat.class;
    private static final Logger log = LoggerFactory.getLogger(CLASS);

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        return AccumuloRecordReader.getSplits(context, CLASS);
    }

    public RecordReader<Key, Value> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new AccumuloRecordReader<Key, Value>(CLASS){

            public boolean nextKeyValue() {
                if (this.scannerIterator.hasNext()) {
                    ++this.numKeysRead;
                    Map.Entry entry = (Map.Entry)this.scannerIterator.next();
                    this.currentKey = (Key)entry.getKey();
                    this.currentK = this.currentKey;
                    this.currentV = entry.getValue();
                    if (log.isTraceEnabled()) {
                        log.trace("Processing key/value pair: " + DefaultFormatter.formatEntry((Map.Entry)entry, (boolean)true));
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static InputFormatBuilder.ClientParams<Job> configure() {
        return new InputFormatBuilderImpl<Job>(CLASS);
    }
}

