/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrations {
    private final EnumMap<Ample.DataLevel, SortedMap<KeyExtent, TServerInstance>> migrations = new EnumMap(Ample.DataLevel.class);
    private static final Logger log = LoggerFactory.getLogger(Migrations.class);

    public Migrations() {
        for (Ample.DataLevel dataLevel : Ample.DataLevel.values()) {
            this.migrations.put(dataLevel, Collections.synchronizedSortedMap(new TreeMap()));
        }
    }

    private void removeIf(Predicate<Map.Entry<KeyExtent, TServerInstance>> removalTest, Ample.DataLevel ... levels) {
        for (Ample.DataLevel dataLevel : levels) {
            SortedMap<KeyExtent, TServerInstance> mmap = this.migrations.get(dataLevel);
            mmap.entrySet().removeIf(entry -> {
                if (removalTest.test((Map.Entry<KeyExtent, TServerInstance>)entry)) {
                    log.trace("Removed migration {} -> {}", entry.getKey(), entry.getValue());
                    return true;
                }
                return false;
            });
        }
    }

    public void removeTable(TableId tableId) {
        this.removeIf(entry -> ((KeyExtent)entry.getKey()).tableId().equals((Object)tableId), Ample.DataLevel.of((TableId)tableId));
    }

    public void removeExtents(Set<KeyExtent> extents) {
        extents.forEach(this::removeExtent);
    }

    public TServerInstance removeExtent(KeyExtent extent) {
        TServerInstance tserver = (TServerInstance)this.migrations.get(Ample.DataLevel.of((TableId)extent.tableId())).remove(extent);
        if (tserver != null) {
            log.trace("Removed migration {} -> {}", (Object)extent, (Object)tserver);
        }
        return tserver;
    }

    public void removeServers(Set<TServerInstance> servers) {
        this.removeIf(entry -> servers.contains(entry.getValue()), Ample.DataLevel.values());
    }

    public void put(KeyExtent extent, TServerInstance tServerInstance) {
        this.migrations.get(Ample.DataLevel.of((TableId)extent.tableId())).put(extent, tServerInstance);
        log.trace("Added migration {} -> {}", (Object)extent, (Object)tServerInstance);
    }

    public TServerInstance get(KeyExtent extent) {
        return (TServerInstance)this.migrations.get(Ample.DataLevel.of((TableId)extent.tableId())).get(extent);
    }

    public Set<KeyExtent> snapshotAll() {
        HashSet copy = new HashSet();
        this.migrations.values().forEach(mset -> {
            SortedMap sortedMap = mset;
            synchronized (sortedMap) {
                copy.addAll(mset.keySet());
            }
        });
        return Collections.unmodifiableSet(copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<KeyExtent> snapshot(Ample.DataLevel dl) {
        SortedMap<KeyExtent, TServerInstance> migrationsForLevel;
        SortedMap<KeyExtent, TServerInstance> sortedMap = migrationsForLevel = this.migrations.get(dl);
        synchronized (sortedMap) {
            return Set.copyOf(migrationsForLevel.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Ample.DataLevel, Set<KeyExtent>> mutableCopy() {
        EnumMap<Ample.DataLevel, Set<KeyExtent>> copy = new EnumMap<Ample.DataLevel, Set<KeyExtent>>(Ample.DataLevel.class);
        for (Ample.DataLevel dataLevel : Ample.DataLevel.values()) {
            SortedMap<KeyExtent, TServerInstance> migrationsForLevel;
            SortedMap<KeyExtent, TServerInstance> sortedMap = migrationsForLevel = this.migrations.get(dataLevel);
            synchronized (sortedMap) {
                copy.put(dataLevel, new HashSet<KeyExtent>(migrationsForLevel.keySet()));
            }
        }
        return copy;
    }

    public boolean isEmpty() {
        for (SortedMap<KeyExtent, TServerInstance> mset : this.migrations.values()) {
            if (mset.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int size() {
        int size = 0;
        for (SortedMap<KeyExtent, TServerInstance> mset : this.migrations.values()) {
            size += mset.size();
        }
        return size;
    }

    public boolean isEmpty(Ample.DataLevel dataLevel) {
        return this.migrations.get(dataLevel).isEmpty();
    }

    public boolean contains(KeyExtent extent) {
        return this.migrations.get(Ample.DataLevel.of((TableId)extent.tableId())).containsKey(extent);
    }
}

