/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesSketchSortedViewIterator;
import org.apache.datasketches.quantilescommon.DoublesSortedView;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public final class DoublesSketchSortedView
implements DoublesSortedView {
    private final double[] quantiles;
    private final long[] cumWeights;
    private final long totalN;

    DoublesSketchSortedView(double[] quantiles, long[] cumWeights, long totalN) {
        this.quantiles = quantiles;
        this.cumWeights = cumWeights;
        this.totalN = totalN;
    }

    public DoublesSketchSortedView(DoublesSketch sketch) {
        this.totalN = sketch.getN();
        int k = sketch.getK();
        int numQuantiles = sketch.getNumRetained();
        this.quantiles = new double[numQuantiles];
        this.cumWeights = new long[numQuantiles];
        DoublesSketchAccessor sketchAccessor = DoublesSketchAccessor.wrap(sketch);
        DoublesSketchSortedView.populateFromDoublesSketch(k, this.totalN, sketch.getBitPattern(), sketchAccessor, this.quantiles, this.cumWeights);
        DoublesSketchSortedView.blockyTandemMergeSort(this.quantiles, this.cumWeights, numQuantiles, k);
        if (DoublesSketchSortedView.convertToCumulative(this.cumWeights) != this.totalN) {
            throw new SketchesStateException("Sorted View is misconfigured. TotalN does not match cumWeights.");
        }
    }

    @Override
    public double getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int len = this.cumWeights.length;
        long naturalRank = searchCrit == QuantileSearchCriteria.INCLUSIVE ? (long)Math.ceil(rank * (double)this.totalN) : (long)Math.floor(rank * (double)this.totalN);
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT;
        int index = InequalitySearch.find(this.cumWeights, 0, len - 1, naturalRank, crit);
        if (index == -1) {
            return this.quantiles[this.quantiles.length - 1];
        }
        return this.quantiles[index];
    }

    @Override
    public double getRank(double quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty at this point.");
        }
        int len = this.quantiles.length;
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.LE : InequalitySearch.LT;
        int index = InequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public double[] getQuantiles() {
        return (double[])this.quantiles.clone();
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public DoublesSketchSortedViewIterator iterator() {
        return new DoublesSketchSortedViewIterator(this.quantiles, this.cumWeights);
    }

    private static final void populateFromDoublesSketch(int k, long n, long bitPattern, DoublesSketchAccessor sketchAccessor, double[] quantilesArr, long[] cumWtsArr) {
        int i;
        long bits;
        long weight = 1L;
        int nxt = 0;
        assert (bits == n / (2L * (long)k));
        int lvl = 0;
        for (bits = bitPattern; bits != 0L; bits >>>= 1) {
            weight *= 2L;
            if ((bits & 1L) > 0L) {
                sketchAccessor.setLevel(lvl);
                for (i = 0; i < sketchAccessor.numItems(); ++i) {
                    quantilesArr[nxt] = sketchAccessor.get(i);
                    cumWtsArr[nxt] = weight;
                    ++nxt;
                }
            }
            ++lvl;
        }
        weight = 1L;
        int startOfBaseBufferBlock = nxt;
        sketchAccessor.setLevel(-1);
        for (i = 0; i < sketchAccessor.numItems(); ++i) {
            quantilesArr[nxt] = sketchAccessor.get(i);
            cumWtsArr[nxt] = weight;
            ++nxt;
        }
        assert (nxt == quantilesArr.length);
        int numSamples = nxt;
        Arrays.sort(quantilesArr, startOfBaseBufferBlock, numSamples);
    }

    static void blockyTandemMergeSort(double[] quantiles, long[] cumWts, int arrLen, int blkSize) {
        assert (blkSize >= 1);
        if (arrLen <= blkSize) {
            return;
        }
        int numblks = arrLen / blkSize;
        if (numblks * blkSize < arrLen) {
            ++numblks;
        }
        assert (numblks * blkSize >= arrLen);
        double[] qSrc = Arrays.copyOf(quantiles, arrLen);
        long[] cwSrc = Arrays.copyOf(cumWts, arrLen);
        DoublesSketchSortedView.blockyTandemMergeSortRecursion(qSrc, cwSrc, quantiles, cumWts, 0, numblks, blkSize, arrLen);
    }

    private static void blockyTandemMergeSortRecursion(double[] qSrc, long[] cwSrc, double[] qDst, long[] cwDst, int grpStart, int grpLen, int blkSize, int arrLim) {
        assert (grpLen > 0);
        if (grpLen == 1) {
            return;
        }
        int grpLen1 = grpLen / 2;
        int grpLen2 = grpLen - grpLen1;
        assert (grpLen1 >= 1);
        assert (grpLen2 >= grpLen1);
        int grpStart1 = grpStart;
        int grpStart2 = grpStart + grpLen1;
        DoublesSketchSortedView.blockyTandemMergeSortRecursion(qDst, cwDst, qSrc, cwSrc, grpStart1, grpLen1, blkSize, arrLim);
        DoublesSketchSortedView.blockyTandemMergeSortRecursion(qDst, cwDst, qSrc, cwSrc, grpStart2, grpLen2, blkSize, arrLim);
        int arrStart1 = grpStart1 * blkSize;
        int arrStart2 = grpStart2 * blkSize;
        int arrLen1 = grpLen1 * blkSize;
        int arrLen2 = grpLen2 * blkSize;
        if (arrStart2 + arrLen2 > arrLim) {
            arrLen2 = arrLim - arrStart2;
        }
        DoublesSketchSortedView.tandemMerge(qSrc, cwSrc, arrStart1, arrLen1, arrStart2, arrLen2, qDst, cwDst, arrStart1);
    }

    private static void tandemMerge(double[] qSrc, long[] cwSrc, int arrStart1, int arrLen1, int arrStart2, int arrLen2, double[] qDst, long[] cwDst, int arrStart3) {
        int arrStop1 = arrStart1 + arrLen1;
        int arrStop2 = arrStart2 + arrLen2;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (qSrc[i2] < qSrc[i1]) {
                qDst[i3] = qSrc[i2];
                cwDst[i3] = cwSrc[i2];
                ++i2;
            } else {
                qDst[i3] = qSrc[i1];
                cwDst[i3] = cwSrc[i1];
                ++i1;
            }
            ++i3;
        }
        if (i1 < arrStop1) {
            System.arraycopy(qSrc, i1, qDst, i3, arrStop1 - i1);
            System.arraycopy(cwSrc, i1, cwDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(qSrc, i2, qDst, i3, arrStop2 - i2);
            System.arraycopy(cwSrc, i2, cwDst, i3, arrStop2 - i2);
        }
    }

    private static long convertToCumulative(long[] array) {
        long subtotal = 0L;
        for (int i = 0; i < array.length; ++i) {
            long newSubtotal;
            subtotal = array[i] = (newSubtotal = subtotal + array[i]);
        }
        return subtotal;
    }
}

