/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.16.0", label="dataformat,transformation,xml", title="Jackson XML")
@XmlRootElement(name="jacksonXml")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JacksonXMLDataFormat
extends DataFormatDefinition
implements ContentTypeHeaderAware {
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlTransient
    private Class<?> jsonView;
    @XmlTransient
    private Class<?> collectionType;
    @XmlAttribute
    @Metadata(label="advanced")
    private String xmlMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String prettyPrint;
    @XmlAttribute(name="unmarshalType")
    private String unmarshalTypeName;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowUnmarshallType;
    @XmlAttribute(name="jsonView")
    private String jsonViewTypeName;
    @XmlAttribute
    private String include;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String allowJmsType;
    @XmlAttribute(name="collectionType")
    @Metadata(label="advanced")
    private String collectionTypeName;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String useList;
    @XmlAttribute
    @Metadata(label="advanced")
    private String timezone;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String enableJaxbAnnotationModule;
    @XmlAttribute
    @Metadata(label="advanced")
    private String moduleClassNames;
    @XmlAttribute
    @Metadata(label="advanced")
    private String moduleRefs;
    @XmlAttribute
    private String enableFeatures;
    @XmlAttribute
    private String disableFeatures;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;

    public JacksonXMLDataFormat() {
        super("jacksonXml");
    }

    protected JacksonXMLDataFormat(JacksonXMLDataFormat builder) {
        super(builder);
        this.unmarshalType = builder.unmarshalType;
        this.jsonView = builder.jsonView;
        this.collectionType = builder.collectionType;
        this.xmlMapper = builder.xmlMapper;
        this.prettyPrint = builder.prettyPrint;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.allowUnmarshallType = builder.allowUnmarshallType;
        this.jsonViewTypeName = builder.jsonViewTypeName;
        this.include = builder.include;
        this.allowJmsType = builder.allowJmsType;
        this.collectionTypeName = builder.collectionTypeName;
        this.useList = builder.useList;
        this.timezone = builder.timezone;
        this.enableJaxbAnnotationModule = builder.enableJaxbAnnotationModule;
        this.moduleClassNames = builder.moduleClassNames;
        this.moduleRefs = builder.moduleRefs;
        this.enableFeatures = builder.enableFeatures;
        this.disableFeatures = builder.disableFeatures;
        this.contentTypeHeader = builder.contentTypeHeader;
    }

    private JacksonXMLDataFormat(Builder builder) {
        this();
        this.unmarshalType = builder.unmarshalType;
        this.jsonView = builder.jsonView;
        this.collectionType = builder.collectionType;
        this.xmlMapper = builder.xmlMapper;
        this.prettyPrint = builder.prettyPrint;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.allowUnmarshallType = builder.allowUnmarshallType;
        this.jsonViewTypeName = builder.jsonViewTypeName;
        this.include = builder.include;
        this.allowJmsType = builder.allowJmsType;
        this.collectionTypeName = builder.collectionTypeName;
        this.useList = builder.useList;
        this.timezone = builder.timezone;
        this.enableJaxbAnnotationModule = builder.enableJaxbAnnotationModule;
        this.moduleClassNames = builder.moduleClassNames;
        this.moduleRefs = builder.moduleRefs;
        this.enableFeatures = builder.enableFeatures;
        this.disableFeatures = builder.disableFeatures;
        this.contentTypeHeader = builder.contentTypeHeader;
    }

    @Override
    public JacksonXMLDataFormat copyDefinition() {
        return new JacksonXMLDataFormat(this);
    }

    public String getXmlMapper() {
        return this.xmlMapper;
    }

    public void setXmlMapper(String xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getJsonViewTypeName() {
        return this.jsonViewTypeName;
    }

    public void setJsonViewTypeName(String jsonViewTypeName) {
        this.jsonViewTypeName = jsonViewTypeName;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getAllowJmsType() {
        return this.allowJmsType;
    }

    public void setAllowJmsType(String allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
    }

    public String getUseList() {
        return this.useList;
    }

    public void setUseList(String useList) {
        this.useList = useList;
    }

    public String getEnableJaxbAnnotationModule() {
        return this.enableJaxbAnnotationModule;
    }

    public void setEnableJaxbAnnotationModule(String enableJaxbAnnotationModule) {
        this.enableJaxbAnnotationModule = enableJaxbAnnotationModule;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public String getAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
    }

    @Override
    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<JacksonXMLDataFormat> {
        private Class<?> unmarshalType;
        private Class<?> jsonView;
        private Class<?> collectionType;
        private String xmlMapper;
        private String prettyPrint;
        private String unmarshalTypeName;
        private String allowUnmarshallType;
        private String jsonViewTypeName;
        private String include;
        private String allowJmsType;
        private String collectionTypeName;
        private String useList;
        private String timezone;
        private String enableJaxbAnnotationModule;
        private String moduleClassNames;
        private String moduleRefs;
        private String enableFeatures;
        private String disableFeatures;
        private String contentTypeHeader;

        public Builder xmlMapper(String xmlMapper) {
            this.xmlMapper = xmlMapper;
            return this;
        }

        public Builder prettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return this;
        }

        public Builder prettyPrint(boolean prettyPrint) {
            this.prettyPrint = Boolean.toString(prettyPrint);
            return this;
        }

        public Builder unmarshalTypeName(String unmarshalTypeName) {
            this.unmarshalTypeName = unmarshalTypeName;
            return this;
        }

        public Builder unmarshalType(Class<?> unmarshalType) {
            this.unmarshalType = unmarshalType;
            return this;
        }

        public Builder jsonViewTypeName(String jsonViewTypeName) {
            this.jsonViewTypeName = jsonViewTypeName;
            return this;
        }

        public Builder jsonView(Class<?> jsonView) {
            this.jsonView = jsonView;
            return this;
        }

        public Builder include(String include) {
            this.include = include;
            return this;
        }

        public Builder allowJmsType(String allowJmsType) {
            this.allowJmsType = allowJmsType;
            return this;
        }

        public Builder allowJmsType(boolean allowJmsType) {
            this.allowJmsType = Boolean.toString(allowJmsType);
            return this;
        }

        public Builder collectionTypeName(String collectionTypeName) {
            this.collectionTypeName = collectionTypeName;
            return this;
        }

        public Builder collectionType(Class<?> collectionType) {
            this.collectionType = collectionType;
            return this;
        }

        public Builder useList(String useList) {
            this.useList = useList;
            return this;
        }

        public Builder useList(boolean useList) {
            this.useList = Boolean.toString(useList);
            return this;
        }

        public Builder enableJaxbAnnotationModule(String enableJaxbAnnotationModule) {
            this.enableJaxbAnnotationModule = enableJaxbAnnotationModule;
            return this;
        }

        public Builder enableJaxbAnnotationModule(boolean enableJaxbAnnotationModule) {
            this.enableJaxbAnnotationModule = Boolean.toString(enableJaxbAnnotationModule);
            return this;
        }

        public Builder moduleClassNames(String moduleClassNames) {
            this.moduleClassNames = moduleClassNames;
            return this;
        }

        public Builder moduleRefs(String moduleRefs) {
            this.moduleRefs = moduleRefs;
            return this;
        }

        public Builder enableFeatures(String enableFeatures) {
            this.enableFeatures = enableFeatures;
            return this;
        }

        public Builder disableFeatures(String disableFeatures) {
            this.disableFeatures = disableFeatures;
            return this;
        }

        public Builder allowUnmarshallType(String allowUnmarshallType) {
            this.allowUnmarshallType = allowUnmarshallType;
            return this;
        }

        public Builder allowUnmarshallType(boolean allowUnmarshallType) {
            this.allowUnmarshallType = Boolean.toString(allowUnmarshallType);
            return this;
        }

        public Builder contentTypeHeader(String contentTypeHeader) {
            this.contentTypeHeader = contentTypeHeader;
            return this;
        }

        public Builder contentTypeHeader(boolean contentTypeHeader) {
            this.contentTypeHeader = Boolean.toString(contentTypeHeader);
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        @Override
        public JacksonXMLDataFormat end() {
            return new JacksonXMLDataFormat(this);
        }
    }
}

