/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.Map;

public class RestConfiguration {
    public static final String CORS_ACCESS_CONTROL_ALLOW_ORIGIN = "*";
    public static final String CORS_ACCESS_CONTROL_ALLOW_METHODS = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
    public static final String CORS_ACCESS_CONTROL_MAX_AGE = "3600";
    public static final String CORS_ACCESS_CONTROL_ALLOW_HEADERS = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
    public static final String DEFAULT_REST_CONFIGURATION_ID = "rest-configuration";
    private String component;
    private String apiComponent;
    private String producerComponent;
    private String producerApiDoc;
    private String scheme;
    private String host;
    private boolean useXForwardHeaders;
    private String apiHost;
    private int port;
    private String contextPath;
    private String apiContextPath;
    private String apiContextRouteId;
    private boolean apiVendorExtension;
    private RestHostNameResolver hostNameResolver = RestHostNameResolver.allLocalIp;
    private RestBindingMode bindingMode = RestBindingMode.off;
    private String bindingPackageScan;
    private boolean skipBindingOnErrorCode = true;
    private boolean clientRequestValidation;
    private boolean clientResponseValidation;
    private boolean inlineRoutes = true;
    private boolean enableCORS;
    private boolean enableNoContentResponse;
    private String jsonDataFormat;
    private String xmlDataFormat;
    private Map<String, Object> componentProperties;
    private Map<String, Object> endpointProperties;
    private Map<String, Object> consumerProperties;
    private Map<String, Object> dataFormatProperties;
    private Map<String, Object> apiProperties;
    private Map<String, String> corsHeaders;
    private Map<String, String> validationLevels;

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String componentName) {
        this.component = componentName;
    }

    public String getApiComponent() {
        return this.apiComponent;
    }

    public void setApiComponent(String apiComponent) {
        this.apiComponent = apiComponent;
    }

    public String getProducerComponent() {
        return this.producerComponent;
    }

    public void setProducerComponent(String componentName) {
        this.producerComponent = componentName;
    }

    public String getProducerApiDoc() {
        return this.producerApiDoc;
    }

    public void setProducerApiDoc(String producerApiDoc) {
        this.producerApiDoc = producerApiDoc;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isUseXForwardHeaders() {
        return this.useXForwardHeaders;
    }

    public void setUseXForwardHeaders(boolean useXForwardHeaders) {
        this.useXForwardHeaders = useXForwardHeaders;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getApiContextPath() {
        return this.apiContextPath;
    }

    public void setApiContextPath(String contextPath) {
        this.apiContextPath = contextPath;
    }

    public String getApiContextRouteId() {
        return this.apiContextRouteId;
    }

    public void setApiContextRouteId(String apiContextRouteId) {
        this.apiContextRouteId = apiContextRouteId;
    }

    public boolean isApiVendorExtension() {
        return this.apiVendorExtension;
    }

    public void setApiVendorExtension(boolean apiVendorExtension) {
        this.apiVendorExtension = apiVendorExtension;
    }

    public RestHostNameResolver getHostNameResolver() {
        return this.hostNameResolver;
    }

    public void setHostNameResolver(RestHostNameResolver hostNameResolver) {
        this.hostNameResolver = hostNameResolver;
    }

    public void setHostNameResolver(String hostNameResolver) {
        this.hostNameResolver = RestHostNameResolver.valueOf(hostNameResolver);
    }

    public RestBindingMode getBindingMode() {
        return this.bindingMode;
    }

    public void setBindingMode(RestBindingMode bindingMode) {
        this.bindingMode = bindingMode;
    }

    public void setBindingMode(String bindingMode) {
        this.bindingMode = RestBindingMode.valueOf(bindingMode);
    }

    public String getBindingPackageScan() {
        return this.bindingPackageScan;
    }

    public void setBindingPackageScan(String bindingPackageScan) {
        this.bindingPackageScan = bindingPackageScan;
    }

    public boolean isSkipBindingOnErrorCode() {
        return this.skipBindingOnErrorCode;
    }

    public void setSkipBindingOnErrorCode(boolean skipBindingOnErrorCode) {
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
    }

    public boolean isClientRequestValidation() {
        return this.clientRequestValidation;
    }

    public void setClientRequestValidation(boolean clientRequestValidation) {
        this.clientRequestValidation = clientRequestValidation;
    }

    public boolean isClientResponseValidation() {
        return this.clientResponseValidation;
    }

    public void setClientResponseValidation(boolean clientResponseValidation) {
        this.clientResponseValidation = clientResponseValidation;
    }

    public boolean isEnableCORS() {
        return this.enableCORS;
    }

    public void setEnableCORS(boolean enableCORS) {
        this.enableCORS = enableCORS;
    }

    public boolean isEnableNoContentResponse() {
        return this.enableNoContentResponse;
    }

    public void setEnableNoContentResponse(boolean enableNoContentResponse) {
        this.enableNoContentResponse = enableNoContentResponse;
    }

    public boolean isInlineRoutes() {
        return this.inlineRoutes;
    }

    public void setInlineRoutes(boolean inlineRoutes) {
        this.inlineRoutes = inlineRoutes;
    }

    public String getJsonDataFormat() {
        return this.jsonDataFormat;
    }

    public void setJsonDataFormat(String name) {
        this.jsonDataFormat = name;
    }

    public String getXmlDataFormat() {
        return this.xmlDataFormat;
    }

    public void setXmlDataFormat(String name) {
        this.xmlDataFormat = name;
    }

    public Map<String, Object> getComponentProperties() {
        return this.componentProperties;
    }

    public void setComponentProperties(Map<String, Object> componentProperties) {
        this.componentProperties = componentProperties;
    }

    public Map<String, Object> getEndpointProperties() {
        return this.endpointProperties;
    }

    public void setEndpointProperties(Map<String, Object> endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    public Map<String, Object> getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(Map<String, Object> consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    public Map<String, Object> getDataFormatProperties() {
        return this.dataFormatProperties;
    }

    public void setDataFormatProperties(Map<String, Object> dataFormatProperties) {
        this.dataFormatProperties = dataFormatProperties;
    }

    public Map<String, Object> getApiProperties() {
        return this.apiProperties;
    }

    public void setApiProperties(Map<String, Object> apiProperties) {
        this.apiProperties = apiProperties;
    }

    public Map<String, String> getCorsHeaders() {
        return this.corsHeaders;
    }

    public void setCorsHeaders(Map<String, String> corsHeaders) {
        this.corsHeaders = corsHeaders;
    }

    public Map<String, String> getValidationLevels() {
        return this.validationLevels;
    }

    public void setValidationLevels(Map<String, String> validationLevels) {
        this.validationLevels = validationLevels;
    }

    public static enum RestHostNameResolver {
        allLocalIp,
        localIp,
        localHostName,
        none;

    }

    public static enum RestBindingMode {
        auto,
        off,
        json,
        xml,
        json_xml;

    }
}

