/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.List;
import java.util.Set;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.ContentTypeHeaderAware;
import org.apache.camel.spi.Metadata;

public abstract class FhirDataformat
extends DataFormatDefinition
implements ContentTypeHeaderAware {
    @XmlAttribute
    @Metadata(enums="DSTU2,DSTU2_HL7ORG,DSTU2_1,DSTU3,R4,R5", defaultValue="R4")
    private String fhirVersion;
    @XmlAttribute
    @Metadata(label="advanced")
    private String fhirContext;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String prettyPrint;
    @XmlAttribute
    @Metadata(label="advanced")
    private String parserErrorHandler;
    @XmlAttribute
    @Metadata(label="advanced")
    private String parserOptions;
    @XmlAttribute
    @Metadata(label="advanced")
    private String preferTypes;
    @XmlAttribute
    @Metadata(label="advanced")
    private String forceResourceId;
    @XmlAttribute
    @Metadata(label="advanced")
    private String serverBaseUrl;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String omitResourceId;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String encodeElementsAppliesToChildResourcesOnly;
    @XmlAttribute
    @Metadata(label="advanced")
    private String encodeElements;
    @XmlAttribute
    @Metadata(label="advanced")
    private String dontEncodeElements;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String stripVersionsFromReferences;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String overrideResourceIdWithBundleEntryFullUrl;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String summaryMode;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String suppressNarratives;
    @XmlAttribute
    @Metadata(label="advanced")
    private String dontStripVersionsFromReferencesAtPaths;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;

    protected FhirDataformat(String dataFormatName) {
        super(dataFormatName);
    }

    protected FhirDataformat(FhirDataformat source) {
        super(source);
        this.fhirContext = source.fhirContext;
        this.fhirVersion = source.fhirVersion;
        this.prettyPrint = source.prettyPrint;
        this.parserErrorHandler = source.parserErrorHandler;
        this.parserOptions = source.parserOptions;
        this.preferTypes = source.preferTypes;
        this.forceResourceId = source.forceResourceId;
        this.serverBaseUrl = source.serverBaseUrl;
        this.omitResourceId = source.omitResourceId;
        this.encodeElementsAppliesToChildResourcesOnly = source.encodeElementsAppliesToChildResourcesOnly;
        this.encodeElements = source.encodeElements;
        this.dontEncodeElements = source.dontEncodeElements;
        this.stripVersionsFromReferences = source.stripVersionsFromReferences;
        this.overrideResourceIdWithBundleEntryFullUrl = source.overrideResourceIdWithBundleEntryFullUrl;
        this.summaryMode = source.summaryMode;
        this.suppressNarratives = source.suppressNarratives;
        this.dontStripVersionsFromReferencesAtPaths = source.dontStripVersionsFromReferencesAtPaths;
        this.contentTypeHeader = source.contentTypeHeader;
    }

    protected FhirDataformat() {
    }

    protected FhirDataformat(String dataFormatName, AbstractBuilder<?, ?> builder) {
        this(dataFormatName);
        this.fhirContext = builder.fhirContext;
        this.fhirVersion = builder.fhirVersion;
        this.prettyPrint = builder.prettyPrint;
        this.parserErrorHandler = builder.parserErrorHandler;
        this.parserOptions = builder.parserOptions;
        this.preferTypes = builder.preferTypes;
        this.forceResourceId = builder.forceResourceId;
        this.serverBaseUrl = builder.serverBaseUrl;
        this.omitResourceId = builder.omitResourceId;
        this.encodeElementsAppliesToChildResourcesOnly = builder.encodeElementsAppliesToChildResourcesOnly;
        this.encodeElements = builder.encodeElements;
        this.dontEncodeElements = builder.dontEncodeElements;
        this.stripVersionsFromReferences = builder.stripVersionsFromReferences;
        this.overrideResourceIdWithBundleEntryFullUrl = builder.overrideResourceIdWithBundleEntryFullUrl;
        this.summaryMode = builder.summaryMode;
        this.suppressNarratives = builder.suppressNarratives;
        this.dontStripVersionsFromReferencesAtPaths = builder.dontStripVersionsFromReferencesAtPaths;
        this.contentTypeHeader = builder.contentTypeHeader;
    }

    public String getFhirContext() {
        return this.fhirContext;
    }

    public void setFhirContext(String fhirContext) {
        this.fhirContext = fhirContext;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(String fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    public String getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(String prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getParserErrorHandler() {
        return this.parserErrorHandler;
    }

    public void setParserErrorHandler(String parserErrorHandler) {
        this.parserErrorHandler = parserErrorHandler;
    }

    public String getParserOptions() {
        return this.parserOptions;
    }

    public void setParserOptions(String parserOptions) {
        this.parserOptions = parserOptions;
    }

    public String getPreferTypes() {
        return this.preferTypes;
    }

    public void setPreferTypes(String preferTypes) {
        this.preferTypes = preferTypes;
    }

    public String getForceResourceId() {
        return this.forceResourceId;
    }

    public void setForceResourceId(String forceResourceId) {
        this.forceResourceId = forceResourceId;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public void setServerBaseUrl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    public String getOmitResourceId() {
        return this.omitResourceId;
    }

    public void setOmitResourceId(String omitResourceId) {
        this.omitResourceId = omitResourceId;
    }

    public String getEncodeElementsAppliesToChildResourcesOnly() {
        return this.encodeElementsAppliesToChildResourcesOnly;
    }

    public void setEncodeElementsAppliesToChildResourcesOnly(String encodeElementsAppliesToChildResourcesOnly) {
        this.encodeElementsAppliesToChildResourcesOnly = encodeElementsAppliesToChildResourcesOnly;
    }

    public String getEncodeElements() {
        return this.encodeElements;
    }

    public void setEncodeElements(Set<String> encodeElements) {
        this.encodeElements = String.join((CharSequence)",", encodeElements);
    }

    public void setEncodeElements(String encodeElements) {
        this.encodeElements = encodeElements;
    }

    public String getDontEncodeElements() {
        return this.dontEncodeElements;
    }

    public void setDontEncodeElements(Set<String> dontEncodeElements) {
        this.dontEncodeElements = String.join((CharSequence)",", dontEncodeElements);
    }

    public void setDontEncodeElements(String dontEncodeElements) {
        this.dontEncodeElements = dontEncodeElements;
    }

    public String getStripVersionsFromReferences() {
        return this.stripVersionsFromReferences;
    }

    public void setStripVersionsFromReferences(String stripVersionsFromReferences) {
        this.stripVersionsFromReferences = stripVersionsFromReferences;
    }

    public String getOverrideResourceIdWithBundleEntryFullUrl() {
        return this.overrideResourceIdWithBundleEntryFullUrl;
    }

    public void setOverrideResourceIdWithBundleEntryFullUrl(String overrideResourceIdWithBundleEntryFullUrl) {
        this.overrideResourceIdWithBundleEntryFullUrl = overrideResourceIdWithBundleEntryFullUrl;
    }

    public String getSummaryMode() {
        return this.summaryMode;
    }

    public void setSummaryMode(String summaryMode) {
        this.summaryMode = summaryMode;
    }

    public String getSuppressNarratives() {
        return this.suppressNarratives;
    }

    public void setSuppressNarratives(String suppressNarratives) {
        this.suppressNarratives = suppressNarratives;
    }

    public String getDontStripVersionsFromReferencesAtPaths() {
        return this.dontStripVersionsFromReferencesAtPaths;
    }

    public void setDontStripVersionsFromReferencesAtPaths(List<String> dontStripVersionsFromReferencesAtPaths) {
        this.dontStripVersionsFromReferencesAtPaths = String.join((CharSequence)",", dontStripVersionsFromReferencesAtPaths);
    }

    public void setDontStripVersionsFromReferencesAtPaths(String dontStripVersionsFromReferencesAtPaths) {
        this.dontStripVersionsFromReferencesAtPaths = dontStripVersionsFromReferencesAtPaths;
    }

    @Override
    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    @Override
    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    @XmlTransient
    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T, F>, F extends FhirDataformat>
    implements DataFormatBuilder<F> {
        private String fhirContext;
        private String fhirVersion;
        private String prettyPrint;
        private String parserErrorHandler;
        private String parserOptions;
        private String preferTypes;
        private String forceResourceId;
        private String serverBaseUrl;
        private String omitResourceId;
        private String encodeElementsAppliesToChildResourcesOnly;
        private String encodeElements;
        private String dontEncodeElements;
        private String stripVersionsFromReferences;
        private String overrideResourceIdWithBundleEntryFullUrl;
        private String summaryMode;
        private String suppressNarratives;
        private String dontStripVersionsFromReferencesAtPaths;
        private String contentTypeHeader;

        protected AbstractBuilder() {
        }

        public T fhirContext(String fhirContext) {
            this.fhirContext = fhirContext;
            return (T)this;
        }

        public T fhirVersion(String fhirVersion) {
            this.fhirVersion = fhirVersion;
            return (T)this;
        }

        public T prettyPrint(String prettyPrint) {
            this.prettyPrint = prettyPrint;
            return (T)this;
        }

        public T prettyPrint(boolean prettyPrint) {
            this.prettyPrint = Boolean.toString(prettyPrint);
            return (T)this;
        }

        public T parserErrorHandler(String parserErrorHandler) {
            this.parserErrorHandler = parserErrorHandler;
            return (T)this;
        }

        public T parserOptions(String parserOptions) {
            this.parserOptions = parserOptions;
            return (T)this;
        }

        public T preferTypes(String preferTypes) {
            this.preferTypes = preferTypes;
            return (T)this;
        }

        public T forceResourceId(String forceResourceId) {
            this.forceResourceId = forceResourceId;
            return (T)this;
        }

        public T serverBaseUrl(String serverBaseUrl) {
            this.serverBaseUrl = serverBaseUrl;
            return (T)this;
        }

        public T omitResourceId(String omitResourceId) {
            this.omitResourceId = omitResourceId;
            return (T)this;
        }

        public T omitResourceId(boolean omitResourceId) {
            this.omitResourceId = Boolean.toString(omitResourceId);
            return (T)this;
        }

        public T encodeElementsAppliesToChildResourcesOnly(String encodeElementsAppliesToChildResourcesOnly) {
            this.encodeElementsAppliesToChildResourcesOnly = encodeElementsAppliesToChildResourcesOnly;
            return (T)this;
        }

        public T encodeElementsAppliesToChildResourcesOnly(boolean encodeElementsAppliesToChildResourcesOnly) {
            this.encodeElementsAppliesToChildResourcesOnly = Boolean.toString(encodeElementsAppliesToChildResourcesOnly);
            return (T)this;
        }

        public T encodeElements(Set<String> encodeElements) {
            this.encodeElements = String.join((CharSequence)",", encodeElements);
            return (T)this;
        }

        public T encodeElements(String encodeElements) {
            this.encodeElements = encodeElements;
            return (T)this;
        }

        public T dontEncodeElements(Set<String> dontEncodeElements) {
            this.dontEncodeElements = String.join((CharSequence)",", dontEncodeElements);
            return (T)this;
        }

        public T dontEncodeElements(String dontEncodeElements) {
            this.dontEncodeElements = dontEncodeElements;
            return (T)this;
        }

        public T stripVersionsFromReferences(String stripVersionsFromReferences) {
            this.stripVersionsFromReferences = stripVersionsFromReferences;
            return (T)this;
        }

        public T stripVersionsFromReferences(boolean stripVersionsFromReferences) {
            this.stripVersionsFromReferences = Boolean.toString(stripVersionsFromReferences);
            return (T)this;
        }

        public T overrideResourceIdWithBundleEntryFullUrl(String overrideResourceIdWithBundleEntryFullUrl) {
            this.overrideResourceIdWithBundleEntryFullUrl = overrideResourceIdWithBundleEntryFullUrl;
            return (T)this;
        }

        public T overrideResourceIdWithBundleEntryFullUrl(boolean overrideResourceIdWithBundleEntryFullUrl) {
            this.overrideResourceIdWithBundleEntryFullUrl = Boolean.toString(overrideResourceIdWithBundleEntryFullUrl);
            return (T)this;
        }

        public T summaryMode(String summaryMode) {
            this.summaryMode = summaryMode;
            return (T)this;
        }

        public T summaryMode(boolean summaryMode) {
            this.summaryMode = Boolean.toString(summaryMode);
            return (T)this;
        }

        public T suppressNarratives(String suppressNarratives) {
            this.suppressNarratives = suppressNarratives;
            return (T)this;
        }

        public T suppressNarratives(boolean suppressNarratives) {
            this.suppressNarratives = Boolean.toString(suppressNarratives);
            return (T)this;
        }

        public T dontStripVersionsFromReferencesAtPaths(List<String> dontStripVersionsFromReferencesAtPaths) {
            this.dontStripVersionsFromReferencesAtPaths = String.join((CharSequence)",", dontStripVersionsFromReferencesAtPaths);
            return (T)this;
        }

        public T dontStripVersionsFromReferencesAtPaths(String dontStripVersionsFromReferencesAtPaths) {
            this.dontStripVersionsFromReferencesAtPaths = dontStripVersionsFromReferencesAtPaths;
            return (T)this;
        }

        public T contentTypeHeader(String contentTypeHeader) {
            this.contentTypeHeader = contentTypeHeader;
            return (T)this;
        }

        public T contentTypeHeader(boolean contentTypeHeader) {
            this.contentTypeHeader = Boolean.toString(contentTypeHeader);
            return (T)this;
        }
    }
}

