/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import io.hawt.web.filters.HttpHeaderFilter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyPinningFilter
extends HttpHeaderFilter {
    private static final Logger LOG = LoggerFactory.getLogger(PublicKeyPinningFilter.class);
    private static final String PUBLIC_KEY_PINS = "http.publicKeyPins";
    private String headerValue;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.headerValue = this.getConfigParameter(PUBLIC_KEY_PINS);
        if (this.headerValue != null) {
            LOG.debug("Public Key Pinning is enabled: {}", (Object)this.headerValue);
        } else {
            LOG.debug("Public Key Pinning is disabled");
        }
    }

    @Override
    protected void addHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (this.headerValue != null) {
            response.addHeader("Public-Key-Pins", this.headerValue);
        }
    }
}

