/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.Serializable;
import java.util.Objects;

public final class Pair<A, B>
implements Serializable {
    private static final long serialVersionUID = -2496357457812368127L;
    private A a;
    private B b;
    private int hash = -1;

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public int hashCode() {
        if (this.hash == -1) {
            if (this.a == null && this.b == null) {
                return super.hashCode();
            }
            this.hash = Objects.hash(this.a, this.b);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return Objects.equals(other.a, this.a) && Objects.equals(other.b, this.b);
    }

    public String toString() {
        return "Pair[a=" + String.valueOf(this.a) + ", b=" + String.valueOf(this.b) + "]";
    }

    public void setA(A a) {
        this.hash = -1;
        this.a = a;
    }

    public A getA() {
        return this.a;
    }

    public void setB(B b) {
        this.hash = -1;
        this.b = b;
    }

    public B getB() {
        return this.b;
    }
}

