/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.util.Locale;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.JdbcValueBindingsImpl;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.sql.model.EntityMutationOperationGroup;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;

public class MutationExecutorPostInsertSingleTable
implements MutationExecutor,
JdbcValueBindingsImpl.JdbcValueDescriptorAccess {
    private final EntityMutationTarget mutationTarget;
    private final SharedSessionContractImplementor session;
    private final PreparableMutationOperation operation;
    private final PreparedStatementDetails identityInsertStatementDetails;
    private final JdbcValueBindingsImpl valueBindings;

    public MutationExecutorPostInsertSingleTable(EntityMutationOperationGroup mutationOperationGroup, SharedSessionContractImplementor session) {
        this.mutationTarget = mutationOperationGroup.getMutationTarget();
        this.session = session;
        assert (mutationOperationGroup.getNumberOfOperations() == 1);
        this.operation = (PreparableMutationOperation)mutationOperationGroup.getOperation(this.mutationTarget.getIdentifierTableName());
        this.identityInsertStatementDetails = ModelMutationHelper.identityPreparation(this.operation, session);
        this.valueBindings = new JdbcValueBindingsImpl(MutationType.INSERT, this.mutationTarget, this, session);
    }

    @Override
    public JdbcValueDescriptor resolveValueDescriptor(String tableName, String columnName, ParameterUsage usage) {
        assert (this.identityInsertStatementDetails.getMutatingTableDetails().getTableName().equals(tableName));
        return this.operation.findValueDescriptor(columnName, usage);
    }

    @Override
    public JdbcValueBindings getJdbcValueBindings() {
        return this.valueBindings;
    }

    @Override
    public PreparedStatementDetails getPreparedStatementDetails(String tableName) {
        if (this.mutationTarget.getIdentifierTableName().equals(tableName)) {
            return this.identityInsertStatementDetails;
        }
        return null;
    }

    @Override
    public Object execute(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        InsertGeneratedIdentifierDelegate identityHandler = this.mutationTarget.getIdentityInsertDelegate();
        Object id = identityHandler.performInsert(this.identityInsertStatementDetails, this.valueBindings, modelReference, session);
        if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isTraceEnabled()) {
            ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("Post-insert generated value : `%s` (%s)", id, (Object)this.mutationTarget.getNavigableRole().getFullPath());
        }
        return id;
    }

    @Override
    public void release() {
        this.identityInsertStatementDetails.releaseStatement(this.session);
    }

    public String toString() {
        return String.format(Locale.ROOT, "MutationExecutorPostInsertSingleTable(`%s`)", this.mutationTarget.getNavigableRole().getFullPath());
    }
}

