/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.cache.internal.DisabledCaching;
import org.hibernate.cache.internal.EnabledCaching;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceInitiatorContext;

public class CacheInitiator
implements SessionFactoryServiceInitiator<CacheImplementor> {
    public static final @UnknownKeyFor @NonNull @Initialized CacheInitiator INSTANCE = new CacheInitiator();

    @Override
    public @UnknownKeyFor @NonNull @Initialized CacheImplementor initiateService(@UnknownKeyFor @NonNull @Initialized SessionFactoryServiceInitiatorContext context) {
        RegionFactory regionFactory = context.getServiceRegistry().getService(RegionFactory.class);
        return !(regionFactory instanceof NoCachingRegionFactory) ? new EnabledCaching(context.getSessionFactory()) : new DisabledCaching(context.getSessionFactory());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized CacheImplementor> getServiceInitiated() {
        return CacheImplementor.class;
    }
}

