/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;

public class SybaseJConnGetGeneratedKeysDelegate
extends GetGeneratedKeysDelegate {
    private final PostInsertIdentityPersister persister;
    private final Dialect dialect;

    public SybaseJConnGetGeneratedKeysDelegate(PostInsertIdentityPersister persister, Dialect dialect) {
        super(persister, dialect, true);
        this.persister = persister;
        this.dialect = dialect;
    }

    @Override
    public String prepareIdentifierGeneratingInsert(String insertSQL) {
        return this.dialect.getIdentityColumnSupport().appendIdentitySelectToInsert(insertSQL);
    }

    @Override
    public Object executeAndExtract(String insertSql, PreparedStatement insertStatement, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        JdbcServices jdbcServices = session.getJdbcServices();
        ResultSet resultSet = jdbcCoordinator.getResultSetReturn().execute(insertStatement, insertSql);
        try {
            Object object = IdentifierGeneratorHelper.getGeneratedIdentity(this.persister.getNavigableRole().getFullPath(), resultSet, this.persister, session);
            return object;
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to extract generated-keys ResultSet", insertSql);
        }
        finally {
            jdbcCoordinator.getLogicalConnection().getResourceRegistry().release(resultSet, insertStatement);
            jdbcCoordinator.afterStatementExecution();
        }
    }
}

