/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.dotnet.wix;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ant.dotnet.DotNetExecTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.DirSet;

public class TallowTask
extends Task {
    private String vm;
    private ArrayList sources = new ArrayList();
    private File source;
    private File target;
    private File wixHome = null;
    private Commandline cmdl = new Commandline();

    public void setVm(String value) {
        this.vm = value;
    }

    public void setSource(File f) {
        this.source = f;
    }

    public void setTarget(File f) {
        this.target = f;
    }

    public void addSources(DirSet ds) {
        this.sources.add(ds);
    }

    public void setWixHome(File f) {
        this.wixHome = f;
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void execute() {
        Collection grabbedDirs = this.grabSources();
        if (this.target == null) {
            throw new BuildException("You must specify the target if you want to run tallow.");
        }
        this.runTallow(grabbedDirs);
    }

    private Collection grabSources() {
        HashSet<File> r = new HashSet<File>();
        if (this.source != null) {
            if (!this.source.exists()) {
                throw new BuildException("Source " + this.source + " doesn't exist.");
            }
            if (!this.source.isDirectory()) {
                throw new BuildException("Source " + this.source + " is not directory.");
            }
            r.add(this.source);
        } else {
            if (this.sources.size() == 0) {
                throw new BuildException("You must specify at least one source file.");
            }
            Iterator iter = this.sources.iterator();
            while (iter.hasNext()) {
                DirSet ds = (DirSet)iter.next();
                DirectoryScanner scanner = ds.getDirectoryScanner(this.getProject());
                String[] f = scanner.getIncludedDirectories();
                File base = ds.getDir(this.getProject());
                for (int i = 0; i < f.length; ++i) {
                    r.add(new File(base, f[i]));
                }
            }
            if (r.isEmpty()) {
                throw new BuildException("No sources found");
            }
        }
        return r;
    }

    private void runTallow(Collection s) {
        this.run(this.wixExecutable("tallow.exe"), s, this.target, this.cmdl);
    }

    private String wixExecutable(String name) {
        return this.wixHome == null ? name : new File(this.wixHome, name).getAbsolutePath();
    }

    private void run(String executable, Collection s, File target, Commandline cmdl) {
        DotNetExecTask exec = DotNetExecTask.getTask(this, this.vm, executable, null);
        exec.setFailonerror(true);
        exec.setTaskType("wix");
        exec.createArg().setValue("/nologo");
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            File f = (File)iter.next();
            exec.createArg().setValue("-d");
            exec.createArg().setValue(f.getAbsolutePath());
        }
        String[] extraArgs = cmdl.getArguments();
        for (int i = 0; i < extraArgs.length; ++i) {
            exec.createArg().setValue(extraArgs[i]);
        }
        exec.setOutput(target);
        exec.execute();
    }
}

