/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.StringUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlatLedgerManager
extends AbstractZkLedgerManager {
    static final Logger LOG = LoggerFactory.getLogger(FlatLedgerManager.class);
    private final String ledgerPrefix;

    public FlatLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        super(conf, zk);
        this.ledgerPrefix = this.ledgerRootPath + "/" + "L";
    }

    @Override
    public String getLedgerPath(long ledgerId) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ledgerPrefix).append(StringUtils.getZKStringId(ledgerId));
        return sb.toString();
    }

    @Override
    public long getLedgerId(String nodeName) throws IOException {
        long ledgerId;
        try {
            String[] parts = nodeName.split(this.ledgerPrefix);
            ledgerId = Long.parseLong(parts[parts.length - 1]);
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return ledgerId;
    }

    @Override
    public void asyncProcessLedgers(BookkeeperInternalCallbacks.Processor<Long> processor, AsyncCallback.VoidCallback finalCb, Object ctx, int successRc, int failureRc) {
        this.asyncProcessLedgersInSingleNode(this.ledgerRootPath, processor, finalCb, ctx, successRc, failureRc);
    }

    @Override
    public LedgerManager.LedgerRangeIterator getLedgerRanges(final long zkOpTimeoutMs) {
        return new LedgerManager.LedgerRangeIterator(){
            boolean nextCalled = false;
            LedgerManager.LedgerRange nextRange = null;

            private synchronized void preload() throws IOException {
                if (this.nextRange != null) {
                    return;
                }
                NavigableSet<Long> zkActiveLedgers = null;
                try {
                    zkActiveLedgers = FlatLedgerManager.this.ledgerListToSet(ZkUtils.getChildrenInSingleNode(FlatLedgerManager.this.zk, FlatLedgerManager.this.ledgerRootPath, zkOpTimeoutMs), FlatLedgerManager.this.ledgerRootPath);
                    this.nextRange = new LedgerManager.LedgerRange(zkActiveLedgers);
                }
                catch (KeeperException.NoNodeException e) {
                    throw new IOException("Path does not exist: " + FlatLedgerManager.this.ledgerRootPath, e);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Error when get child nodes from zk", ie);
                }
            }

            @Override
            public synchronized boolean hasNext() throws IOException {
                this.preload();
                return this.nextRange != null && this.nextRange.size() > 0 && !this.nextCalled;
            }

            @Override
            public synchronized LedgerManager.LedgerRange next() throws IOException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.nextCalled = true;
                return this.nextRange;
            }
        };
    }

    @Override
    protected String getLedgerParentNodeRegex() {
        return "L\\d{10}";
    }
}

