/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.modes.gcm;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.crypto.internal.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.internal.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private List lookupPowX2;

    public void init(byte[] byArray) {
        int[] nArray = GCMUtil.asInts(byArray);
        if (this.lookupPowX2 != null && Arrays.areEqual(nArray, (int[])this.lookupPowX2.get(0))) {
            return;
        }
        this.lookupPowX2 = new ArrayList(8);
        this.lookupPowX2.add(nArray);
    }

    public void exponentiateX(long l, byte[] byArray) {
        int[] nArray = GCMUtil.oneAsInts();
        int n = 0;
        while (l > 0L) {
            if ((l & 1L) != 0L) {
                GCMUtil.multiply(nArray, this.getMultiplier(n));
            }
            ++n;
            l >>>= 1;
        }
        GCMUtil.asBytes(nArray, byArray);
    }

    private int[] getMultiplier(int n) {
        this.ensureAvailable(n);
        return (int[])this.lookupPowX2.get(n);
    }

    private void ensureAvailable(int n) {
        int n2 = this.lookupPowX2.size();
        if (n2 <= n) {
            int[] nArray = (int[])this.lookupPowX2.get(n2 - 1);
            do {
                nArray = Arrays.clone(nArray);
                GCMUtil.multiply(nArray, nArray);
                this.lookupPowX2.add(nArray);
            } while (++n2 <= n);
        }
    }
}

