/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import org.apache.zookeeper.server.watch.PathParentIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathParentIteratorTest {
    @Test
    public void testRoot() {
        PathParentIterator pathParentIterator = PathParentIterator.forAll((String)"/");
        Assertions.assertTrue((boolean)pathParentIterator.hasNext());
        Assertions.assertFalse((boolean)pathParentIterator.atParentPath());
        Assertions.assertEquals((Object)pathParentIterator.next(), (Object)"/");
        Assertions.assertFalse((boolean)pathParentIterator.hasNext());
    }

    @Test
    public void test1Level() {
        PathParentIterator pathParentIterator = PathParentIterator.forAll((String)"/a");
        Assertions.assertTrue((boolean)pathParentIterator.hasNext());
        Assertions.assertFalse((boolean)pathParentIterator.atParentPath());
        Assertions.assertEquals((Object)pathParentIterator.next(), (Object)"/a");
        Assertions.assertTrue((boolean)pathParentIterator.hasNext());
        Assertions.assertEquals((Object)pathParentIterator.next(), (Object)"/");
        Assertions.assertTrue((boolean)pathParentIterator.atParentPath());
        Assertions.assertFalse((boolean)pathParentIterator.hasNext());
    }

    @Test
    public void testLong() {
        PathParentIterator pathParentIterator = PathParentIterator.forAll((String)"/a/b/c/d");
        Assertions.assertTrue((boolean)pathParentIterator.hasNext());
        Assertions.assertEquals((Object)pathParentIterator.next(), (Object)"/a/b/c/d");
        Assertions.assertFalse((boolean)pathParentIterator.atParentPath());
        Assertions.assertTrue((boolean)pathParentIterator.hasNext());
        Assertions.assertEquals((Object)pathParentIterator.next(), (Object)"/a/b/c");
        Assertions.assertTrue((boolean)pathParentIterator.atParentPath());
        Assertions.assertTrue((boolean)pathParentIterator.hasNext());
        Assertions.assertEquals((Object)pathParentIterator.next(), (Object)"/a/b");
        Assertions.assertTrue((boolean)pathParentIterator.atParentPath());
        Assertions.assertTrue((boolean)pathParentIterator.hasNext());
        Assertions.assertEquals((Object)pathParentIterator.next(), (Object)"/a");
        Assertions.assertTrue((boolean)pathParentIterator.atParentPath());
        Assertions.assertTrue((boolean)pathParentIterator.hasNext());
        Assertions.assertEquals((Object)pathParentIterator.next(), (Object)"/");
        Assertions.assertTrue((boolean)pathParentIterator.atParentPath());
        Assertions.assertFalse((boolean)pathParentIterator.hasNext());
    }

    @Test
    public void testForPathOnly() {
        PathParentIterator pathParentIterator = PathParentIterator.forPathOnly((String)"/a/b/c/d");
        Assertions.assertTrue((boolean)pathParentIterator.hasNext());
        Assertions.assertEquals((Object)pathParentIterator.next(), (Object)"/a/b/c/d");
        Assertions.assertFalse((boolean)pathParentIterator.atParentPath());
        Assertions.assertFalse((boolean)pathParentIterator.hasNext());
    }
}

