/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.otel;

import io.netty.util.internal.PlatformDependent;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Classes;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Cpu;
import io.opentelemetry.instrumentation.runtimemetrics.java8.GarbageCollector;
import io.opentelemetry.instrumentation.runtimemetrics.java8.MemoryPools;
import io.opentelemetry.instrumentation.runtimemetrics.java8.Threads;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.ExperimentalBufferPools;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.stats.otel.OtelCounter;
import org.apache.bookkeeper.stats.otel.OtelOpStatsLogger;
import org.apache.bookkeeper.stats.otel.OtelStatsLogger;
import org.apache.bookkeeper.stats.otel.ScopeContext;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtelMetricsProvider
implements StatsProvider {
    private static final Logger log = LoggerFactory.getLogger(OtelMetricsProvider.class);
    private static final String METER_NAME = "org.apache.bookkeeper";
    final ConcurrentMap<ScopeContext, OtelCounter> counters = new ConcurrentHashMap<ScopeContext, OtelCounter>();
    final ConcurrentMap<ScopeContext, OtelOpStatsLogger> opStats = new ConcurrentHashMap<ScopeContext, OtelOpStatsLogger>();
    private static final List<Double> histogramBuckets = Arrays.asList(0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0);
    private final OpenTelemetry openTelemetry;
    final Meter meter;
    private static final AtomicLong directMemoryUsage;
    private static final Optional<BufferPoolMXBean> poolMxBeanOp;
    private static final Supplier<Double> getDirectMemoryUsage;

    OtelMetricsProvider() {
        AutoConfiguredOpenTelemetrySdk sdk = AutoConfiguredOpenTelemetrySdk.builder().addMeterProviderCustomizer((sdkMeterProviderBuilder, configProperties) -> sdkMeterProviderBuilder.registerView(InstrumentSelector.builder().setMeterName(METER_NAME).setType(InstrumentType.HISTOGRAM).build(), View.builder().setAggregation(Aggregation.explicitBucketHistogram(histogramBuckets)).build())).build();
        this.openTelemetry = sdk.getOpenTelemetrySdk();
        this.meter = this.openTelemetry.getMeter(METER_NAME);
    }

    public void start(Configuration conf) {
        boolean exposeDefaultJVMMetrics = conf.getBoolean("exposeDefaultJVMMetrics", true);
        if (exposeDefaultJVMMetrics) {
            MemoryPools.registerObservers((OpenTelemetry)this.openTelemetry);
            ExperimentalBufferPools.registerObservers((OpenTelemetry)this.openTelemetry);
            Classes.registerObservers((OpenTelemetry)this.openTelemetry);
            Cpu.registerObservers((OpenTelemetry)this.openTelemetry);
            Threads.registerObservers((OpenTelemetry)this.openTelemetry);
            GarbageCollector.registerObservers((OpenTelemetry)this.openTelemetry, (boolean)true);
            this.meter.gaugeBuilder("process.runtime.jvm.memory.direct_bytes_used").buildWithCallback(odm -> odm.record(getDirectMemoryUsage.get().doubleValue()));
            this.meter.gaugeBuilder("process.runtime.jvm.memory.direct_bytes_max").buildWithCallback(odm -> odm.record((double)PlatformDependent.estimateMaxDirectMemory()));
        }
    }

    public void stop() {
    }

    public StatsLogger getStatsLogger(String scope) {
        return new OtelStatsLogger(this, scope, Attributes.empty());
    }

    static {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            poolMxBeanOp = Optional.empty();
            AtomicLong tmpDirectMemoryUsage = null;
            try {
                Field field = PlatformDependent.class.getDeclaredField("DIRECT_MEMORY_COUNTER");
                field.setAccessible(true);
                tmpDirectMemoryUsage = (AtomicLong)field.get(null);
            }
            catch (Throwable t) {
                log.warn("Failed to access netty DIRECT_MEMORY_COUNTER field {}", (Object)t.getMessage());
            }
            directMemoryUsage = tmpDirectMemoryUsage;
            getDirectMemoryUsage = () -> directMemoryUsage != null ? (double)directMemoryUsage.get() : Double.NaN;
        } else {
            directMemoryUsage = null;
            List<BufferPoolMXBean> platformMXBeans = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
            poolMxBeanOp = platformMXBeans.stream().filter(bufferPoolMXBean -> bufferPoolMXBean.getName().equals("direct")).findAny();
            getDirectMemoryUsage = () -> poolMxBeanOp.isPresent() ? (double)poolMxBeanOp.get().getMemoryUsed() : Double.NaN;
        }
    }
}

