/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Store and retrieve objects from IBM Cloud Object Storage.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface IBMCOSEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the IBM Cloud Object Storage component.
     */
    public interface IBMCOSEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedIBMCOSEndpointConsumerBuilder advanced() {
            return (AdvancedIBMCOSEndpointConsumerBuilder) this;
        }
        /**
         * Automatically create the bucket if it doesn't exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Automatically create the bucket if it doesn't exist.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder autoCreateBucket(String autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * The delimiter to use for listing objects.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * IBM COS Endpoint URL (e.g.,
         * https://s3.us-south.cloud-object-storage.appdomain.cloud).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param endpointUrl the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder endpointUrl(String endpointUrl) {
            doSetProperty("endpointUrl", endpointUrl);
            return this;
        }
        /**
         * IBM COS Location/Region (e.g., us-south, eu-gb).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param location the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder location(String location) {
            doSetProperty("location", location);
            return this;
        }
        /**
         * The prefix to use for listing objects.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * Delete the object from IBM COS after it has been retrieved.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder deleteAfterRead(boolean deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Delete the object from IBM COS after it has been retrieved.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder deleteAfterRead(String deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * The destination bucket to move objects to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param destinationBucket the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder destinationBucket(String destinationBucket) {
            doSetProperty("destinationBucket", destinationBucket);
            return this;
        }
        /**
         * The prefix to add to objects in the destination bucket.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param destinationBucketPrefix the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder destinationBucketPrefix(String destinationBucketPrefix) {
            doSetProperty("destinationBucketPrefix", destinationBucketPrefix);
            return this;
        }
        /**
         * The suffix to add to objects in the destination bucket.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param destinationBucketSuffix the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder destinationBucketSuffix(String destinationBucketSuffix) {
            doSetProperty("destinationBucketSuffix", destinationBucketSuffix);
            return this;
        }
        /**
         * To get the object from the bucket with the given file name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param fileName the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder fileName(String fileName) {
            doSetProperty("fileName", fileName);
            return this;
        }
        /**
         * Include the object body in the exchange.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeBody the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder includeBody(boolean includeBody) {
            doSetProperty("includeBody", includeBody);
            return this;
        }
        /**
         * Include the object body in the exchange.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeBody the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder includeBody(String includeBody) {
            doSetProperty("includeBody", includeBody);
            return this;
        }
        /**
         * Include folders/directories when listing objects.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeFolders the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder includeFolders(boolean includeFolders) {
            doSetProperty("includeFolders", includeFolders);
            return this;
        }
        /**
         * Include folders/directories when listing objects.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeFolders the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder includeFolders(String includeFolders) {
            doSetProperty("includeFolders", includeFolders);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder maxMessagesPerPoll(int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Default: 10
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder maxMessagesPerPoll(String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Move the object to a different bucket after it has been retrieved.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param moveAfterRead the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder moveAfterRead(boolean moveAfterRead) {
            doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }
        /**
         * Move the object to a different bucket after it has been retrieved.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param moveAfterRead the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder moveAfterRead(String moveAfterRead) {
            doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder runLoggingLevel(org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder schedulerProperties(String key, Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler. This is a multi-value
         * option with prefix: scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * IBM Cloud API Key for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
        /**
         * IBM COS Service Instance ID (CRN).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param serviceInstanceId the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointConsumerBuilder serviceInstanceId(String serviceInstanceId) {
            doSetProperty("serviceInstanceId", serviceInstanceId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the IBM Cloud Object Storage component.
     */
    public interface AdvancedIBMCOSEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default IBMCOSEndpointConsumerBuilder basic() {
            return (IBMCOSEndpointConsumerBuilder) this;
        }
        /**
         * Whether to automatically close the object input stream after
         * processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param autocloseBody the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder autocloseBody(boolean autocloseBody) {
            doSetProperty("autocloseBody", autocloseBody);
            return this;
        }
        /**
         * Whether to automatically close the object input stream after
         * processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param autocloseBody the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder autocloseBody(String autocloseBody) {
            doSetProperty("autocloseBody", autocloseBody);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable in-progress repository to track objects being consumed.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.IdempotentRepository</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param inProgressRepository the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder inProgressRepository(org.apache.camel.spi.IdempotentRepository inProgressRepository) {
            doSetProperty("inProgressRepository", inProgressRepository);
            return this;
        }
        /**
         * A pluggable in-progress repository to track objects being consumed.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.IdempotentRepository</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param inProgressRepository the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder inProgressRepository(String inProgressRepository) {
            doSetProperty("inProgressRepository", inProgressRepository);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder pollStrategy(org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder pollStrategy(String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Reference to an IBM COS Client instance in the registry.
         * 
         * The option is a:
         * <code>com.ibm.cloud.objectstorage.services.s3.AmazonS3</code> type.
         * 
         * Group: advanced
         * 
         * @param cosClient the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder cosClient(com.ibm.cloud.objectstorage.services.s3.AmazonS3 cosClient) {
            doSetProperty("cosClient", cosClient);
            return this;
        }
        /**
         * Reference to an IBM COS Client instance in the registry.
         * 
         * The option will be converted to a
         * <code>com.ibm.cloud.objectstorage.services.s3.AmazonS3</code> type.
         * 
         * Group: advanced
         * 
         * @param cosClient the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointConsumerBuilder cosClient(String cosClient) {
            doSetProperty("cosClient", cosClient);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the IBM Cloud Object Storage component.
     */
    public interface IBMCOSEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedIBMCOSEndpointProducerBuilder advanced() {
            return (AdvancedIBMCOSEndpointProducerBuilder) this;
        }

        /**
         * Automatically create the bucket if it doesn't exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Automatically create the bucket if it doesn't exist.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder autoCreateBucket(String autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * The delimiter to use for listing objects.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * IBM COS Endpoint URL (e.g.,
         * https://s3.us-south.cloud-object-storage.appdomain.cloud).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param endpointUrl the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder endpointUrl(String endpointUrl) {
            doSetProperty("endpointUrl", endpointUrl);
            return this;
        }
        /**
         * IBM COS Location/Region (e.g., us-south, eu-gb).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param location the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder location(String location) {
            doSetProperty("location", location);
            return this;
        }
        /**
         * The prefix to use for listing objects.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * Delete the object from the local filesystem after uploading.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param deleteAfterWrite the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder deleteAfterWrite(boolean deleteAfterWrite) {
            doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }
        /**
         * Delete the object from the local filesystem after uploading.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param deleteAfterWrite the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder deleteAfterWrite(String deleteAfterWrite) {
            doSetProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }
        /**
         * The key name for the object.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param keyName the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder keyName(String keyName) {
            doSetProperty("keyName", keyName);
            return this;
        }
        /**
         * Use multi-part upload for large files.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param multiPartUpload the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder multiPartUpload(boolean multiPartUpload) {
            doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }
        /**
         * Use multi-part upload for large files.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param multiPartUpload the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder multiPartUpload(String multiPartUpload) {
            doSetProperty("multiPartUpload", multiPartUpload);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.ibm.cos.IBMCOSOperations</code>
         * type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder operation(org.apache.camel.component.ibm.cos.IBMCOSOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.ibm.cos.IBMCOSOperations</code>
         * type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Part size for multi-part uploads (default 25MB).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 26214400
         * Group: producer
         * 
         * @param partSize the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder partSize(long partSize) {
            doSetProperty("partSize", partSize);
            return this;
        }
        /**
         * Part size for multi-part uploads (default 25MB).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 26214400
         * Group: producer
         * 
         * @param partSize the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder partSize(String partSize) {
            doSetProperty("partSize", partSize);
            return this;
        }
        /**
         * The storage class to use when storing objects (e.g., STANDARD, VAULT,
         * COLD, FLEX).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param storageClass the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder storageClass(String storageClass) {
            doSetProperty("storageClass", storageClass);
            return this;
        }
        /**
         * IBM Cloud API Key for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
        /**
         * IBM COS Service Instance ID (CRN).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param serviceInstanceId the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointProducerBuilder serviceInstanceId(String serviceInstanceId) {
            doSetProperty("serviceInstanceId", serviceInstanceId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the IBM Cloud Object Storage component.
     */
    public interface AdvancedIBMCOSEndpointProducerBuilder extends EndpointProducerBuilder {
        default IBMCOSEndpointProducerBuilder basic() {
            return (IBMCOSEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Reference to an IBM COS Client instance in the registry.
         * 
         * The option is a:
         * <code>com.ibm.cloud.objectstorage.services.s3.AmazonS3</code> type.
         * 
         * Group: advanced
         * 
         * @param cosClient the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointProducerBuilder cosClient(com.ibm.cloud.objectstorage.services.s3.AmazonS3 cosClient) {
            doSetProperty("cosClient", cosClient);
            return this;
        }
        /**
         * Reference to an IBM COS Client instance in the registry.
         * 
         * The option will be converted to a
         * <code>com.ibm.cloud.objectstorage.services.s3.AmazonS3</code> type.
         * 
         * Group: advanced
         * 
         * @param cosClient the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointProducerBuilder cosClient(String cosClient) {
            doSetProperty("cosClient", cosClient);
            return this;
        }
    }

    /**
     * Builder for endpoint for the IBM Cloud Object Storage component.
     */
    public interface IBMCOSEndpointBuilder
            extends
                IBMCOSEndpointConsumerBuilder,
                IBMCOSEndpointProducerBuilder {
        default AdvancedIBMCOSEndpointBuilder advanced() {
            return (AdvancedIBMCOSEndpointBuilder) this;
        }

        /**
         * Automatically create the bucket if it doesn't exist.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Automatically create the bucket if it doesn't exist.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder autoCreateBucket(String autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * The delimiter to use for listing objects.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param delimiter the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder delimiter(String delimiter) {
            doSetProperty("delimiter", delimiter);
            return this;
        }
        /**
         * IBM COS Endpoint URL (e.g.,
         * https://s3.us-south.cloud-object-storage.appdomain.cloud).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param endpointUrl the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder endpointUrl(String endpointUrl) {
            doSetProperty("endpointUrl", endpointUrl);
            return this;
        }
        /**
         * IBM COS Location/Region (e.g., us-south, eu-gb).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param location the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder location(String location) {
            doSetProperty("location", location);
            return this;
        }
        /**
         * The prefix to use for listing objects.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * IBM Cloud API Key for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
        /**
         * IBM COS Service Instance ID (CRN).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param serviceInstanceId the value to set
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder serviceInstanceId(String serviceInstanceId) {
            doSetProperty("serviceInstanceId", serviceInstanceId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IBM Cloud Object Storage component.
     */
    public interface AdvancedIBMCOSEndpointBuilder
            extends
                AdvancedIBMCOSEndpointConsumerBuilder,
                AdvancedIBMCOSEndpointProducerBuilder {
        default IBMCOSEndpointBuilder basic() {
            return (IBMCOSEndpointBuilder) this;
        }

        /**
         * Reference to an IBM COS Client instance in the registry.
         * 
         * The option is a:
         * <code>com.ibm.cloud.objectstorage.services.s3.AmazonS3</code> type.
         * 
         * Group: advanced
         * 
         * @param cosClient the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointBuilder cosClient(com.ibm.cloud.objectstorage.services.s3.AmazonS3 cosClient) {
            doSetProperty("cosClient", cosClient);
            return this;
        }
        /**
         * Reference to an IBM COS Client instance in the registry.
         * 
         * The option will be converted to a
         * <code>com.ibm.cloud.objectstorage.services.s3.AmazonS3</code> type.
         * 
         * Group: advanced
         * 
         * @param cosClient the value to set
         * @return the dsl builder
         */
        default AdvancedIBMCOSEndpointBuilder cosClient(String cosClient) {
            doSetProperty("cosClient", cosClient);
            return this;
        }
    }

    public interface IBMCOSBuilders {
        /**
         * IBM Cloud Object Storage (camel-ibm-cos)
         * Store and retrieve objects from IBM Cloud Object Storage.
         * 
         * Category: cloud,file
         * Since: 4.16
         * Maven coordinates: org.apache.camel:camel-ibm-cos
         * 
         * @return the dsl builder for the headers' name.
         */
        default IBMCOSHeaderNameBuilder ibmCos() {
            return IBMCOSHeaderNameBuilder.INSTANCE;
        }
        /**
         * IBM Cloud Object Storage (camel-ibm-cos)
         * Store and retrieve objects from IBM Cloud Object Storage.
         * 
         * Category: cloud,file
         * Since: 4.16
         * Maven coordinates: org.apache.camel:camel-ibm-cos
         * 
         * Syntax: <code>ibm-cos:bucketName</code>
         * 
         * Path parameter: bucketName (required)
         * Bucket name
         * 
         * @param path bucketName
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder ibmCos(String path) {
            return IBMCOSEndpointBuilderFactory.endpointBuilder("ibm-cos", path);
        }
        /**
         * IBM Cloud Object Storage (camel-ibm-cos)
         * Store and retrieve objects from IBM Cloud Object Storage.
         * 
         * Category: cloud,file
         * Since: 4.16
         * Maven coordinates: org.apache.camel:camel-ibm-cos
         * 
         * Syntax: <code>ibm-cos:bucketName</code>
         * 
         * Path parameter: bucketName (required)
         * Bucket name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path bucketName
         * @return the dsl builder
         */
        default IBMCOSEndpointBuilder ibmCos(String componentName, String path) {
            return IBMCOSEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the IBM Cloud Object Storage component.
     */
    public static class IBMCOSHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final IBMCOSHeaderNameBuilder INSTANCE = new IBMCOSHeaderNameBuilder();

        /**
         * The bucket Name which this object will be stored or which will be
         * used for the current operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSBucketName}.
         */
        public String iBMCOSBucketName() {
            return "CamelIBMCOSBucketName";
        }
        /**
         * The bucket Destination Name which will be used for the current
         * operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMCOSBucketDestinationName}.
         */
        public String iBMCOSBucketDestinationName() {
            return "CamelIBMCOSBucketDestinationName";
        }
        /**
         * The optional Cache-Control HTTP header which allows the user to
         * specify caching behavior.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSContentControl}.
         */
        public String iBMCOSContentControl() {
            return "CamelIBMCOSContentControl";
        }
        /**
         * The optional Content-Disposition HTTP header, which specifies
         * presentational information such as the recommended filename.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSContentDisposition}.
         */
        public String iBMCOSContentDisposition() {
            return "CamelIBMCOSContentDisposition";
        }
        /**
         * The optional Content-Encoding HTTP header specifying what content
         * encodings have been applied to the object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSContentEncoding}.
         */
        public String iBMCOSContentEncoding() {
            return "CamelIBMCOSContentEncoding";
        }
        /**
         * The Content-Length HTTP header indicating the size of the associated
         * object in bytes.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSContentLength}.
         */
        public String iBMCOSContentLength() {
            return "CamelIBMCOSContentLength";
        }
        /**
         * The base64 encoded 128-bit MD5 digest of the associated object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSContentMD5}.
         */
        public String iBMCOSContentMD5() {
            return "CamelIBMCOSContentMD5";
        }
        /**
         * The Content-Type HTTP header, which indicates the type of content
         * stored in the associated object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSContentType}.
         */
        public String iBMCOSContentType() {
            return "CamelIBMCOSContentType";
        }
        /**
         * The ETag value for the object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSETag}.
         */
        public String iBMCOSETag() {
            return "CamelIBMCOSETag";
        }
        /**
         * The key under which this object is stored or will be stored.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSKey}.
         */
        public String iBMCOSKey() {
            return "CamelIBMCOSKey";
        }
        /**
         * The Destination key which will be used for the current operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMCOSDestinationKey}.
         */
        public String iBMCOSDestinationKey() {
            return "CamelIBMCOSDestinationKey";
        }
        /**
         * The value of the Last-Modified header, indicating the date and time
         * at which IBM COS last recorded a modification to the object.
         * 
         * The option is a: {@code java.util.Date} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSLastModified}.
         */
        public String iBMCOSLastModified() {
            return "CamelIBMCOSLastModified";
        }
        /**
         * The version ID of the associated IBM COS object if available.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSVersionId}.
         */
        public String iBMCOSVersionId() {
            return "CamelIBMCOSVersionId";
        }
        /**
         * The operation to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSOperation}.
         */
        public String iBMCOSOperation() {
            return "CamelIBMCOSOperation";
        }
        /**
         * The prefix which is used to filter objects.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSPrefix}.
         */
        public String iBMCOSPrefix() {
            return "CamelIBMCOSPrefix";
        }
        /**
         * The delimiter which is used to filter objects.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSDelimiter}.
         */
        public String iBMCOSDelimiter() {
            return "CamelIBMCOSDelimiter";
        }
        /**
         * A list of keys to delete when using deleteObjects operation.
         * 
         * The option is a: {@code java.util.List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMCOSKeysToDelete}.
         */
        public String iBMCOSKeysToDelete() {
            return "CamelIBMCOSKeysToDelete";
        }
        /**
         * A map of metadata to be stored with the object in IBM COS.
         * 
         * The option is a: {@code java.util.Map<String, String>} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code IBMCOSMetadata}.
         */
        public String iBMCOSMetadata() {
            return "CamelIBMCOSMetadata";
        }
        /**
         * The range start position for partial object retrieval.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMCOSRangeStart}.
         */
        public String iBMCOSRangeStart() {
            return "CamelIBMCOSRangeStart";
        }
        /**
         * The range end position for partial object retrieval.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMCOSRangeEnd}.
         */
        public String iBMCOSRangeEnd() {
            return "CamelIBMCOSRangeEnd";
        }
        /**
         * Whether the bucket exists or not.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMCOSBucketExists}.
         */
        public String iBMCOSBucketExists() {
            return "CamelIBMCOSBucketExists";
        }
    }
    static IBMCOSEndpointBuilder endpointBuilder(String componentName, String path) {
        class IBMCOSEndpointBuilderImpl extends AbstractEndpointBuilder implements IBMCOSEndpointBuilder, AdvancedIBMCOSEndpointBuilder {
            public IBMCOSEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new IBMCOSEndpointBuilderImpl(path);
    }
}