/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
)

// ServerApplyConfiguration represents a declarative configuration of the Server type for use
// with apply.
type ServerApplyConfiguration struct {
	ID            *string             `json:"id,omitempty"`
	Username      *string             `json:"username,omitempty"`
	Password      *string             `json:"password,omitempty"`
	Configuration *camelv1.Properties `json:"configuration,omitempty"`
}

// ServerApplyConfiguration constructs a declarative configuration of the Server type for use with
// apply.
func Server() *ServerApplyConfiguration {
	return &ServerApplyConfiguration{}
}

// WithID sets the ID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ID field is set to the value of the last call.
func (b *ServerApplyConfiguration) WithID(value string) *ServerApplyConfiguration {
	b.ID = &value
	return b
}

// WithUsername sets the Username field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Username field is set to the value of the last call.
func (b *ServerApplyConfiguration) WithUsername(value string) *ServerApplyConfiguration {
	b.Username = &value
	return b
}

// WithPassword sets the Password field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Password field is set to the value of the last call.
func (b *ServerApplyConfiguration) WithPassword(value string) *ServerApplyConfiguration {
	b.Password = &value
	return b
}

// WithConfiguration sets the Configuration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Configuration field is set to the value of the last call.
func (b *ServerApplyConfiguration) WithConfiguration(value camelv1.Properties) *ServerApplyConfiguration {
	b.Configuration = &value
	return b
}
