/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
)

// IntegrationProfileLister helps list IntegrationProfiles.
// All objects returned here must be treated as read-only.
type IntegrationProfileLister interface {
	// List lists all IntegrationProfiles in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*camelv1.IntegrationProfile, err error)
	// IntegrationProfiles returns an object that can list and get IntegrationProfiles.
	IntegrationProfiles(namespace string) IntegrationProfileNamespaceLister
	IntegrationProfileListerExpansion
}

// integrationProfileLister implements the IntegrationProfileLister interface.
type integrationProfileLister struct {
	listers.ResourceIndexer[*camelv1.IntegrationProfile]
}

// NewIntegrationProfileLister returns a new IntegrationProfileLister.
func NewIntegrationProfileLister(indexer cache.Indexer) IntegrationProfileLister {
	return &integrationProfileLister{listers.New[*camelv1.IntegrationProfile](indexer, camelv1.Resource("integrationprofile"))}
}

// IntegrationProfiles returns an object that can list and get IntegrationProfiles.
func (s *integrationProfileLister) IntegrationProfiles(namespace string) IntegrationProfileNamespaceLister {
	return integrationProfileNamespaceLister{listers.NewNamespaced[*camelv1.IntegrationProfile](s.ResourceIndexer, namespace)}
}

// IntegrationProfileNamespaceLister helps list and get IntegrationProfiles.
// All objects returned here must be treated as read-only.
type IntegrationProfileNamespaceLister interface {
	// List lists all IntegrationProfiles in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*camelv1.IntegrationProfile, err error)
	// Get retrieves the IntegrationProfile from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*camelv1.IntegrationProfile, error)
	IntegrationProfileNamespaceListerExpansion
}

// integrationProfileNamespaceLister implements the IntegrationProfileNamespaceLister
// interface.
type integrationProfileNamespaceLister struct {
	listers.ResourceIndexer[*camelv1.IntegrationProfile]
}
