/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
	camelv1 "github.com/apache/camel-k/v2/pkg/client/camel/applyconfiguration/camel/v1"
	typedcamelv1 "github.com/apache/camel-k/v2/pkg/client/camel/clientset/versioned/typed/camel/v1"
	gentype "k8s.io/client-go/gentype"
)

// fakeIntegrationKits implements IntegrationKitInterface
type fakeIntegrationKits struct {
	*gentype.FakeClientWithListAndApply[*v1.IntegrationKit, *v1.IntegrationKitList, *camelv1.IntegrationKitApplyConfiguration]
	Fake *FakeCamelV1
}

func newFakeIntegrationKits(fake *FakeCamelV1, namespace string) typedcamelv1.IntegrationKitInterface {
	return &fakeIntegrationKits{
		gentype.NewFakeClientWithListAndApply[*v1.IntegrationKit, *v1.IntegrationKitList, *camelv1.IntegrationKitApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("integrationkits"),
			v1.SchemeGroupVersion.WithKind("IntegrationKit"),
			func() *v1.IntegrationKit { return &v1.IntegrationKit{} },
			func() *v1.IntegrationKitList { return &v1.IntegrationKitList{} },
			func(dst, src *v1.IntegrationKitList) { dst.ListMeta = src.ListMeta },
			func(list *v1.IntegrationKitList) []*v1.IntegrationKit { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.IntegrationKitList, items []*v1.IntegrationKit) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
