/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.store.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterInfoMapper;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterSystemConfigMapper;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterTenantConfigMapper;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSessionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DBSessionFactory.class);
    private static volatile SqlSessionFactory _instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlSessionFactory get(CelebornConf celebornConf) throws IOException {
        if (_instance != null) return _instance;
        Class<DBSessionFactory> clazz = DBSessionFactory.class;
        synchronized (DBSessionFactory.class) {
            if (_instance != null) return _instance;
            Properties properties = new Properties();
            properties.setProperty("driverClassName", celebornConf.dynamicConfigStoreDbHikariDriverClassName());
            properties.setProperty("jdbcUrl", celebornConf.dynamicConfigStoreDbHikariJdbcUrl());
            properties.setProperty("username", celebornConf.dynamicConfigStoreDbHikariUsername());
            properties.setProperty("password", celebornConf.dynamicConfigStoreDbHikariPassword());
            properties.setProperty("connectionTimeout", String.valueOf(celebornConf.dynamicConfigStoreDbHikariConnectionTimeout()));
            properties.setProperty("idleTimeout", String.valueOf(celebornConf.dynamicConfigStoreDbHikariIdleTimeout()));
            properties.setProperty("maxLifetime", String.valueOf(celebornConf.dynamicConfigStoreDbHikariMaxLifetime()));
            properties.setProperty("maximumPoolSize", String.valueOf(celebornConf.dynamicConfigStoreDbHikariMaximumPoolSize()));
            for (Map.Entry dbPropertiesEntry : celebornConf.dynamicConfigStoreDbHikariCustomConfigs().entrySet()) {
                properties.setProperty(((String)dbPropertiesEntry.getKey()).replace("celeborn.dynamicConfig.store.db.hikari.", ""), (String)dbPropertiesEntry.getValue());
            }
            HikariConfig config = new HikariConfig(properties);
            HikariDataSource dataSource = new HikariDataSource(config);
            JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
            Environment environment = new Environment("celeborn", (TransactionFactory)transactionFactory, (DataSource)dataSource);
            Configuration configuration = new Configuration(environment);
            configuration.setMapUnderscoreToCamelCase(true);
            configuration.addMapper(ClusterInfoMapper.class);
            configuration.addMapper(ClusterSystemConfigMapper.class);
            configuration.addMapper(ClusterTenantConfigMapper.class);
            SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
            _instance = builder.build(configuration);
            LOG.info("Init sqlSessionFactory success");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }
}

