/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.server.common.service.store.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.server.common.service.config.ConfigLevel;
import org.apache.celeborn.server.common.service.config.ConfigService;
import org.apache.celeborn.server.common.service.config.SystemConfig;
import org.apache.celeborn.server.common.service.config.TenantConfig;
import org.apache.celeborn.server.common.service.model.ClusterInfo;
import org.apache.celeborn.server.common.service.model.ClusterSystemConfig;
import org.apache.celeborn.server.common.service.model.ClusterTenantConfig;
import org.apache.celeborn.server.common.service.store.IServiceManager;
import org.apache.celeborn.server.common.service.store.db.DBSessionFactory;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterInfoMapper;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterSystemConfigMapper;
import org.apache.celeborn.server.common.service.store.db.mapper.ClusterTenantConfigMapper;
import org.apache.celeborn.server.common.service.utils.JsonUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbServiceManagerImpl
implements IServiceManager {
    private static final Logger LOG = LoggerFactory.getLogger(DbServiceManagerImpl.class);
    private final CelebornConf celebornConf;
    private final ConfigService configService;
    private final SqlSessionFactory sqlSessionFactory;
    private final int clusterId;
    private final int pageSize;

    public DbServiceManagerImpl(CelebornConf celebornConf, ConfigService configServer) throws IOException {
        this.celebornConf = celebornConf;
        this.sqlSessionFactory = DBSessionFactory.get(celebornConf);
        this.configService = configServer;
        this.pageSize = celebornConf.dynamicConfigStoreDbFetchPageSize();
        this.clusterId = this.createCluster(this.getClusterInfoFromEnv());
    }

    @Override
    public int createCluster(ClusterInfo clusterInfo) {
        ClusterInfo clusterInfoFromDB = this.getClusterInfo(clusterInfo.getName());
        if (clusterInfoFromDB == null) {
            try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
                ClusterInfoMapper mapper = (ClusterInfoMapper)sqlSession.getMapper(ClusterInfoMapper.class);
                clusterInfo.setGmtCreate(new Date());
                clusterInfo.setGmtModify(new Date());
                mapper.insert(clusterInfo);
                LOG.info("Create cluster {} successfully.", (Object)JsonUtils.toJson(clusterInfo));
            }
            catch (Exception e) {
                LOG.warn("Create cluster {} failed: {}.", new Object[]{JsonUtils.toJson(clusterInfo), e.getMessage(), e});
            }
            clusterInfoFromDB = this.getClusterInfo(clusterInfo.getName());
            if (clusterInfoFromDB == null) {
                throw new RuntimeException("Could not get cluster info of " + clusterInfo.getName() + ".");
            }
        }
        return clusterInfoFromDB.getId();
    }

    @Override
    public ClusterInfo getClusterInfo(String clusterName) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            ClusterInfoMapper mapper = (ClusterInfoMapper)sqlSession.getMapper(ClusterInfoMapper.class);
            ClusterInfo clusterInfo = mapper.getClusterInfo(clusterName);
            return clusterInfo;
        }
    }

    @Override
    public List<TenantConfig> getAllTenantConfigs() {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            ClusterTenantConfigMapper mapper = (ClusterTenantConfigMapper)sqlSession.getMapper(ClusterTenantConfigMapper.class);
            int totalNum = mapper.getClusterTenantConfigsNum(this.clusterId, ConfigLevel.TENANT.name());
            ArrayList<ClusterTenantConfig> clusterAllTenantConfigs = new ArrayList<ClusterTenantConfig>();
            for (int offset = 0; offset < totalNum; offset += this.pageSize) {
                List<ClusterTenantConfig> clusterTenantConfigs = mapper.getClusterTenantConfigs(this.clusterId, ConfigLevel.TENANT.name(), offset, this.pageSize);
                clusterAllTenantConfigs.addAll(clusterTenantConfigs);
            }
            Map<String, List<ClusterTenantConfig>> tenantConfigMaps = clusterAllTenantConfigs.stream().collect(Collectors.groupingBy(clusterTenantConfig -> clusterTenantConfig.getTenantId()));
            List<TenantConfig> list = tenantConfigMaps.entrySet().stream().map(t -> new TenantConfig(this.configService, (String)t.getKey(), null, (List)t.getValue())).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public List<TenantConfig> getAllTenantUserConfigs() {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            ClusterTenantConfigMapper mapper = (ClusterTenantConfigMapper)sqlSession.getMapper(ClusterTenantConfigMapper.class);
            int totalNum = mapper.getClusterTenantConfigsNum(this.clusterId, ConfigLevel.TENANT_USER.name());
            ArrayList<ClusterTenantConfig> clusterAllTenantConfigs = new ArrayList<ClusterTenantConfig>();
            for (int offset = 0; offset < totalNum; offset += this.pageSize) {
                List<ClusterTenantConfig> clusterTenantConfigs = mapper.getClusterTenantConfigs(this.clusterId, ConfigLevel.TENANT_USER.name(), offset, this.pageSize);
                clusterAllTenantConfigs.addAll(clusterTenantConfigs);
            }
            Map<Pair, List<ClusterTenantConfig>> tenantConfigMaps = clusterAllTenantConfigs.stream().collect(Collectors.groupingBy(ClusterTenantConfig::getTenantInfo));
            List<TenantConfig> list = tenantConfigMaps.entrySet().stream().map(t -> new TenantConfig(this.configService, (String)((Pair)t.getKey()).getKey(), (String)((Pair)t.getKey()).getValue(), (List)t.getValue())).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public SystemConfig getSystemConfig() {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession();){
            ClusterSystemConfigMapper mapper = (ClusterSystemConfigMapper)sqlSession.getMapper(ClusterSystemConfigMapper.class);
            List<ClusterSystemConfig> clusterSystemConfig = mapper.getClusterSystemConfig(this.clusterId);
            SystemConfig systemConfig = new SystemConfig(this.celebornConf, clusterSystemConfig);
            return systemConfig;
        }
    }

    public ClusterInfo getClusterInfoFromEnv() {
        Map<String, String> env = System.getenv();
        String clusterName = env.getOrDefault("CELEBORN_CLUSTER_NAME", this.celebornConf.clusterName());
        String namespace = env.getOrDefault("CELEBORN_CLUSTER_NAMESPACE", "");
        String endpoint = env.getOrDefault("CELEBORN_CLUSTER_ENDPOINT", "");
        ClusterInfo clusterInfo = new ClusterInfo();
        clusterInfo.setName(clusterName);
        clusterInfo.setNamespace(namespace);
        clusterInfo.setEndpoint(endpoint);
        return clusterInfo;
    }
}

