/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.locale;

import java.text.ParseException;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.ConvertUtils;
import org.apache.commons.beanutils2.locale.LocaleConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseLocaleConverter<T>
implements LocaleConverter<T> {
    private static final Log LOG = LogFactory.getLog(BaseLocaleConverter.class);
    protected final T defaultValue;
    protected final Locale locale;
    protected final boolean localizedPattern;
    protected final String pattern;
    protected final boolean useDefault;

    private static <R> R checkConversionResult(Class<R> type, Object result) {
        if (type == null) {
            return (R)result;
        }
        if (result == null) {
            return null;
        }
        if (type.isInstance(result)) {
            return type.cast(result);
        }
        throw new ConversionException("Unsupported target type: " + type);
    }

    protected BaseLocaleConverter(T defaultValue, Locale locale, String pattern, boolean useDefault, boolean locPattern) {
        this.defaultValue = useDefault ? defaultValue : null;
        this.useDefault = useDefault;
        this.locale = locale != null ? locale : Locale.getDefault();
        this.pattern = pattern;
        this.localizedPattern = locPattern;
    }

    @Override
    public <R> R convert(Class<R> type, Object value) {
        return this.convert(type, value, null);
    }

    @Override
    public <R> R convert(Class<R> type, Object value, String pattern) {
        Class<R> targetType = ConvertUtils.primitiveToWrapper(type);
        if (value == null) {
            if (this.useDefault) {
                return this.getDefaultAs(targetType);
            }
            LOG.debug((Object)"Null value specified for conversion, returning null");
            return null;
        }
        try {
            if (pattern != null) {
                return BaseLocaleConverter.checkConversionResult(targetType, this.parse(value, pattern));
            }
            return BaseLocaleConverter.checkConversionResult(targetType, this.parse(value, this.pattern));
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.getDefaultAs(targetType);
            }
            if (e instanceof ConversionException) {
                throw (ConversionException)e;
            }
            throw new ConversionException(e);
        }
    }

    public Object convert(Object value) {
        return this.convert(value, null);
    }

    public T convert(Object value, String pattern) {
        return (T)this.convert(null, value, pattern);
    }

    private <R> R getDefaultAs(Class<R> type) {
        return BaseLocaleConverter.checkConversionResult(type, this.defaultValue);
    }

    protected abstract T parse(Object var1, String var2) throws ParseException;

    public static abstract class Builder<B extends Builder<B, T>, T> {
        protected T defaultValue;
        protected Locale locale = Locale.getDefault();
        protected boolean localizedPattern;
        protected String pattern;
        protected boolean useDefault;

        protected B asThis() {
            return (B)this;
        }

        public abstract BaseLocaleConverter<?> get();

        public B setDefault(T defaultValue) {
            this.defaultValue = defaultValue;
            return this.asThis();
        }

        public B setLocale(Locale locale) {
            this.locale = locale;
            return this.asThis();
        }

        public B setLocalizedPattern(boolean localizedPattern) {
            this.localizedPattern = localizedPattern;
            return this.asThis();
        }

        public B setPattern(String pattern) {
            this.pattern = pattern;
            return this.asThis();
        }

        public B setUseDefault(boolean useDefault) {
            this.useDefault = useDefault;
            return this.asThis();
        }
    }
}

