/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.function.Predicate;
import org.apache.commons.beanutils2.BeanPredicate;
import org.apache.commons.beanutils2.TestBean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BeanPredicateTest {
    @Test
    public void testEqual() {
        Predicate<String> p = s -> s.equals("foo");
        BeanPredicate predicate = new BeanPredicate("stringProperty", p);
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean("foo")));
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean("bar")));
    }

    @Test
    public void testInstanceOf() {
        Predicate<String> p = String.class::isInstance;
        BeanPredicate predicate = new BeanPredicate("stringProperty", p);
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean("foo")));
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean("bar")));
    }

    @Test
    public void testNotEqual() {
        Predicate<String> p = s -> !s.equals("foo");
        BeanPredicate predicate = new BeanPredicate("stringProperty", p);
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean("foo")));
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean("bar")));
    }

    @Test
    public void testNull() {
        Predicate<String> p = s -> s == null;
        BeanPredicate predicate = new BeanPredicate("stringProperty", p);
        String nullString = null;
        Assertions.assertTrue((boolean)predicate.test((Object)new TestBean(nullString)));
        Assertions.assertFalse((boolean)predicate.test((Object)new TestBean("bar")));
    }
}

