/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils2.BasicDynaBean;
import org.apache.commons.beanutils2.BasicDynaClass;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaBeanPropertyMapDecorator;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynaBeanMapDecoratorTest {
    private static final DynaProperty stringProp = new DynaProperty("stringProp", String.class);
    private static final DynaProperty nullProp = new DynaProperty("nullProp", String.class);
    private static final DynaProperty intProp = new DynaProperty("intProp", Integer.class);
    private static final DynaProperty dateProp = new DynaProperty("dateProp", Date.class);
    private static final DynaProperty mapProp = new DynaProperty("mapProp", Map.class);
    private static final DynaProperty[] properties = new DynaProperty[]{stringProp, nullProp, intProp, dateProp, mapProp};
    private static final DynaClass dynaClass = new BasicDynaClass("testDynaClass", BasicDynaBean.class, properties);
    private static final String stringVal = "somevalue";
    private static final Integer intVal = 5;
    private static final Date dateVal = new Date();
    private static final Map<String, Object> emptyMap = new DynaBeanPropertyMapDecorator((DynaBean)new BasicDynaBean((DynaClass)new BasicDynaClass()));
    private final Map<Object, Object> mapVal = new HashMap<Object, Object>();
    private final Object[] values = new Object[]{"somevalue", null, intVal, dateVal, this.mapVal};
    private BasicDynaBean dynaBean;
    private Map<String, Object> decoratedMap;
    private Map<String, Object> modifiableMap;

    private <E> void checkUnmodifiable(String desc, Collection<E> collection, E addElem) {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> collection.add(addElem));
        ArrayList list = new ArrayList(1);
        list.add(addElem);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> collection.addAll(list));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> collection.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> collection.remove("abc"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> collection.removeAll(list));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> collection.retainAll(list));
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.mapVal.clear();
        this.mapVal.put("key1", "key1Value");
        this.mapVal.put("key2", "key2Value");
        this.dynaBean = new BasicDynaBean(dynaClass);
        for (int i = 0; i < properties.length; ++i) {
            this.dynaBean.set(properties[i].getName(), this.values[i]);
        }
        this.decoratedMap = new DynaBeanPropertyMapDecorator((DynaBean)this.dynaBean);
        this.modifiableMap = new DynaBeanPropertyMapDecorator((DynaBean)this.dynaBean, false);
    }

    @AfterEach
    public void tearDown() {
        this.dynaBean = null;
        this.decoratedMap = null;
        this.modifiableMap = null;
    }

    @Test
    public void testClear() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.decoratedMap.clear());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.modifiableMap.clear());
    }

    @Test
    public void testContainsKey() {
        Assertions.assertTrue((boolean)this.decoratedMap.containsKey(stringProp.getName()), (String)"decoratedMap true");
        Assertions.assertFalse((boolean)this.decoratedMap.containsKey("xyz"), (String)"decoratedMap false");
    }

    @Test
    public void testContainsValue() {
        Assertions.assertTrue((boolean)this.decoratedMap.containsValue(stringVal), (String)"decoratedMap true");
        Assertions.assertFalse((boolean)this.decoratedMap.containsValue("xyz"), (String)"decoratedMap false");
    }

    @Test
    public void testEntrySet() {
        Set<Map.Entry<String, Object>> set = this.modifiableMap.entrySet();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("key", "value");
        this.checkUnmodifiable("entrySet()", set, m.entrySet().iterator().next());
        Assertions.assertEquals((int)properties.length, (int)set.size(), (String)"entrySet size");
        ArrayList<String> namesList = new ArrayList<String>();
        int i = 0;
        for (Map.Entry<String, Object> entry : set) {
            String name = entry.getKey();
            namesList.add(name);
            Object expectValue = this.decoratedMap.get(name);
            Assertions.assertEquals((Object)expectValue, (Object)entry.getValue(), (String)("entrySet(" + i + ") val"));
            ++i;
        }
        for (int j = 0; j < properties.length; ++j) {
            String name = properties[j].getName();
            Assertions.assertTrue((boolean)namesList.contains(name), (String)("Check property[" + j + "]"));
        }
    }

    @Test
    public void testGet() {
        Assertions.assertEquals((Object)stringVal, (Object)this.decoratedMap.get(stringProp.getName()), (String)"decoratedMap valid");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.decoratedMap.get("xyz"));
    }

    @Test
    public void testIsEmpty() {
        Assertions.assertTrue((boolean)emptyMap.isEmpty(), (String)"Empty");
        Assertions.assertFalse((boolean)this.decoratedMap.isEmpty(), (String)"Not Empty");
    }

    @Test
    public void testIsReadOnly() {
        Assertions.assertTrue((boolean)((DynaBeanPropertyMapDecorator)this.decoratedMap).isReadOnly(), (String)"decoratedMap true");
        Assertions.assertFalse((boolean)((DynaBeanPropertyMapDecorator)this.modifiableMap).isReadOnly(), (String)"modifiableMap false");
    }

    @Test
    public void testKeySet() {
        Set<String> set = this.modifiableMap.keySet();
        this.checkUnmodifiable("keySet()", set, "xyz");
        Assertions.assertEquals((int)properties.length, (int)set.size(), (String)"keySet size");
        for (int i = 0; i < properties.length; ++i) {
            String name = properties[i].getName();
            Assertions.assertTrue((boolean)set.contains(name), (String)("Check property[" + i + "]"));
        }
    }

    @Test
    public void testPut() {
        String newValue = "ABC";
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.decoratedMap.put(stringProp.getName(), "ABC"));
        Assertions.assertEquals((Object)stringVal, (Object)this.modifiableMap.put(stringProp.getName(), "ABC"), (String)"modifiableMap put");
        Assertions.assertEquals((Object)"ABC", (Object)this.dynaBean.get(stringProp.getName()), (String)"dynaBean get");
        Assertions.assertEquals((Object)"ABC", (Object)this.modifiableMap.get(stringProp.getName()), (String)"modifiableMap get");
    }

    @Test
    public void testPutAll() {
        String newValue = "ABC";
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put(stringProp.getName(), "ABC");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.decoratedMap.putAll(newMap));
        Assertions.assertEquals((Object)stringVal, (Object)this.dynaBean.get(stringProp.getName()), (String)"before putAll");
        this.modifiableMap.putAll(newMap);
        Assertions.assertEquals((Object)"ABC", (Object)this.dynaBean.get(stringProp.getName()), (String)"after putAll");
    }

    @Test
    public void testRemove() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.decoratedMap.remove(stringProp.getName()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.modifiableMap.remove(stringProp.getName()));
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((int)0, (int)emptyMap.size(), (String)"Empty");
        Assertions.assertEquals((int)properties.length, (int)this.decoratedMap.size(), (String)"Not Empty");
    }

    @Test
    public void testValues() {
        Collection<Object> collection = this.modifiableMap.values();
        this.checkUnmodifiable("values()", collection, "xyz");
        Assertions.assertEquals((int)this.values.length, (int)collection.size(), (String)"values size");
        Iterator<Object> iterator = collection.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assertions.assertEquals((Object)this.values[i], (Object)iterator.next(), (String)("values(" + i + ")"));
            ++i;
        }
    }
}

