/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.sql.RowSetDynaClass;
import org.apache.commons.beanutils2.sql.TestResultSet;
import org.apache.commons.beanutils2.sql.TestResultSetMetaData;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynaRowSetTest {
    protected RowSetDynaClass dynaClass;
    protected String[] columns = new String[]{"bigdecimalproperty", "booleanproperty", "byteproperty", "dateproperty", "doubleproperty", "floatproperty", "intproperty", "longproperty", "nullproperty", "shortproperty", "stringproperty", "timeproperty", "timestampproperty"};

    @BeforeEach
    public void setUp() throws Exception {
        this.dynaClass = new RowSetDynaClass(TestResultSet.createProxy());
    }

    @AfterEach
    public void tearDown() {
        this.dynaClass = null;
    }

    @Test
    public void testGetDynaProperties() {
        DynaProperty[] dynaProps = this.dynaClass.getDynaProperties();
        Assertions.assertNotNull((Object)dynaProps, (String)"dynaProps exists");
        Assertions.assertEquals((int)this.columns.length, (int)dynaProps.length, (String)"dynaProps length");
        for (int i = 0; i < this.columns.length; ++i) {
            Assertions.assertEquals((Object)this.columns[i], (Object)dynaProps[i].getName(), (String)("Property " + this.columns[i]));
        }
    }

    @Test
    public void testGetDynaProperty() {
        Assertions.assertThrows(NullPointerException.class, () -> this.dynaClass.getDynaProperty(null));
        DynaProperty dynaProp = this.dynaClass.getDynaProperty("unknownProperty");
        Assertions.assertNull((Object)dynaProp, (String)"unknown property returns null");
        dynaProp = this.dynaClass.getDynaProperty("stringproperty");
        Assertions.assertNotNull((Object)dynaProp, (String)"string property exists");
        Assertions.assertEquals((Object)"stringproperty", (Object)dynaProp.getName(), (String)"string property name");
        Assertions.assertEquals(String.class, (Object)dynaProp.getType(), (String)"string property class");
    }

    @Test
    public void testGetName() {
        Assertions.assertEquals((Object)"org.apache.commons.beanutils2.sql.RowSetDynaClass", (Object)this.dynaClass.getName(), (String)"DynaClass name");
    }

    @Test
    public void testInconsistentOracleDriver() throws Exception {
        ResultSetMetaData metaData = TestResultSetMetaData.createProxy(new TestResultSetMetaDataInconsistent());
        ResultSet resultSet = TestResultSet.createProxy(new TestResultSetInconsistent(metaData));
        int dateColIdx = 4;
        Assertions.assertEquals((Object)"dateProperty", (Object)metaData.getColumnName(4), (String)"Date Meta Name");
        Assertions.assertEquals((Object)"java.sql.Timestamp", (Object)metaData.getColumnClassName(4), (String)"Date Meta Class");
        Assertions.assertEquals((int)91, (int)metaData.getColumnType(4), (String)"Date Meta Type");
        Assertions.assertEquals(Date.class, resultSet.getObject("dateProperty").getClass(), (String)"Date ResultSet Value");
        int timestampColIdx = 13;
        Assertions.assertEquals((Object)"timestampProperty", (Object)metaData.getColumnName(13), (String)"Timestamp Meta Name");
        Assertions.assertEquals((Object)CustomTimestamp.class.getName(), (Object)metaData.getColumnClassName(13), (String)"Timestamp Meta Class");
        Assertions.assertEquals((int)93, (int)metaData.getColumnType(13), (String)"Timestamp Meta Type");
        Assertions.assertEquals(CustomTimestamp.class, resultSet.getObject("timestampProperty").getClass(), (String)"Timestamp ResultSet Value");
        RowSetDynaClass inconsistentDynaClass = new RowSetDynaClass(resultSet);
        DynaBean firstRow = (DynaBean)inconsistentDynaClass.getRows().get(0);
        DynaProperty property = firstRow.getDynaClass().getDynaProperty("dateproperty");
        Class expectedType = Date.class;
        Assertions.assertEquals(expectedType, (Object)property.getType(), (String)"Date Class");
        Assertions.assertEquals(expectedType, firstRow.get(property.getName()).getClass(), (String)"Date Value");
        property = firstRow.getDynaClass().getDynaProperty("timestampproperty");
        expectedType = Timestamp.class;
        Assertions.assertEquals(expectedType, (Object)property.getType(), (String)"Timestamp Class");
        Assertions.assertEquals(expectedType, firstRow.get(property.getName()).getClass(), (String)"Timestamp Value");
    }

    @Test
    public void testLimitedRows() throws Exception {
        RowSetDynaClass limitedDynaClass = new RowSetDynaClass(TestResultSet.createProxy(), 3);
        List rows = limitedDynaClass.getRows();
        Assertions.assertNotNull((Object)rows, (String)"list exists");
        Assertions.assertEquals((int)3, (int)rows.size(), (String)"limited row count");
    }

    @Test
    public void testListCount() {
        List rows = this.dynaClass.getRows();
        Assertions.assertNotNull((Object)rows, (String)"list exists");
        Assertions.assertEquals((int)5, (int)rows.size(), (String)"list row count");
    }

    @Test
    public void testListResults() {
        List rows = this.dynaClass.getRows();
        DynaBean row = (DynaBean)rows.get(2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> row.get("unknownProperty"));
        Object bigDecimalProperty = row.get("bigdecimalproperty");
        Assertions.assertNotNull((Object)bigDecimalProperty, (String)"bigDecimalProperty exists");
        Assertions.assertInstanceOf(BigDecimal.class, (Object)bigDecimalProperty, (String)"bigDecimalProperty type");
        Assertions.assertEquals((double)123.45, (double)((BigDecimal)bigDecimalProperty).doubleValue(), (double)0.005, (String)"bigDecimalProperty value");
        Object intProperty = row.get("intproperty");
        Assertions.assertNotNull((Object)intProperty, (String)"intProperty exists");
        Assertions.assertInstanceOf(Integer.class, (Object)intProperty, (String)"intProperty type");
        Assertions.assertEquals((int)103, (int)((Integer)intProperty), (String)"intProperty value");
        Object nullProperty = row.get("nullproperty");
        Assertions.assertNull((Object)nullProperty, (String)"nullProperty null");
        Object stringProperty = row.get("stringproperty");
        Assertions.assertNotNull((Object)stringProperty, (String)"stringProperty exists");
        Assertions.assertInstanceOf(String.class, (Object)stringProperty, (String)"stringProperty type");
        Assertions.assertEquals((Object)"This is a string", (Object)((String)stringProperty), (String)"stringProperty value");
    }

    @Test
    public void testListResultsNormalCase() throws Exception {
        RowSetDynaClass dynaClass = new RowSetDynaClass(TestResultSet.createProxy(), false);
        List rows = dynaClass.getRows();
        DynaBean row = (DynaBean)rows.get(2);
        Assertions.assertThrows(IllegalArgumentException.class, () -> row.get("unknownProperty"));
        Object bigDecimalProperty = row.get("bigDecimalProperty");
        Assertions.assertNotNull((Object)bigDecimalProperty, (String)"bigDecimalProperty exists");
        Assertions.assertInstanceOf(BigDecimal.class, (Object)bigDecimalProperty, (String)"bigDecimalProperty type");
        Assertions.assertEquals((double)123.45, (double)((BigDecimal)bigDecimalProperty).doubleValue(), (double)0.005, (String)"bigDecimalProperty value");
        Object intProperty = row.get("intProperty");
        Assertions.assertNotNull((Object)intProperty, (String)"intProperty exists");
        Assertions.assertInstanceOf(Integer.class, (Object)intProperty, (String)"intProperty type");
        Assertions.assertEquals((int)103, (int)((Integer)intProperty), (String)"intProperty value");
        Object nullProperty = row.get("nullProperty");
        Assertions.assertNull((Object)nullProperty, (String)"nullProperty null");
        Object stringProperty = row.get("stringProperty");
        Assertions.assertNotNull((Object)stringProperty, (String)"stringProperty exists");
        Assertions.assertInstanceOf(String.class, (Object)stringProperty, (String)"stringProperty type");
        Assertions.assertEquals((Object)"This is a string", (Object)((String)stringProperty), (String)"stringProperty value");
    }

    @Test
    public void testNewInstance() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.dynaClass.newInstance());
    }

    private static class TestResultSetMetaDataInconsistent
    extends TestResultSetMetaData {
        private TestResultSetMetaDataInconsistent() {
        }

        @Override
        public String getColumnClassName(int columnIndex) throws SQLException {
            String columnName = this.getColumnName(columnIndex);
            if (columnName.equals("dateProperty")) {
                return Timestamp.class.getName();
            }
            if (columnName.equals("timestampProperty")) {
                return CustomTimestamp.class.getName();
            }
            return super.getColumnClassName(columnIndex);
        }
    }

    private static class TestResultSetInconsistent
    extends TestResultSet {
        public TestResultSetInconsistent(ResultSetMetaData metaData) {
            super(metaData);
        }

        @Override
        public Object getObject(String columnName) throws SQLException {
            if ("timestampProperty".equals(columnName)) {
                return new CustomTimestamp();
            }
            return super.getObject(columnName);
        }
    }

    private static class CustomTimestamp {
        private final long timestamp = new java.util.Date().getTime();

        private CustomTimestamp() {
        }

        public String toString() {
            return "CustomTimestamp[" + this.timestamp + "]";
        }
    }
}

