/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.beanutils2;

/**
 * Bean that has primitive properties
 */
public class PrimitiveBean {

    private float _float;
    private double _double;
    private boolean _boolean;
    private long _long;
    private int _int;

    public boolean getBoolean() {
        return _boolean;
    }

    public double getDouble() {
        return _double;
    }

    public float getFloat() {
        return _float;
    }

    public int getInt() {
        return _int;
    }

    public long getLong() {
        return _long;
    }

    public void setBoolean(final boolean _boolean) {
        this._boolean = _boolean;
    }

    public void setDouble(final double _double) {
        this._double = _double;
    }

    public void setFloat(final float _float) {
        this._float = _float;
    }

    public void setInt(final int _int) {
        this._int = _int;
    }

    public void setLong(final long _long) {
        this._long = _long;
    }
}
