/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.example;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.example.AptHelpAppendable;
import org.apache.commons.cli.help.TableDefinition;
import org.apache.commons.cli.help.TextStyle;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AptHelpAppendableTest {
    private StringBuilder sb;
    private AptHelpAppendable underTest;

    AptHelpAppendableTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.sb = new StringBuilder();
        this.underTest = new AptHelpAppendable(this.sb);
    }

    @Test
    void testAppendFormatTest() throws IOException {
        this.underTest.appendFormat("Big %s and Phantom %,d", new Object[]{"Joe", 309});
        Assertions.assertEquals((Object)String.format("Big Joe and Phantom 309", new Object[0]), (Object)this.sb.toString());
    }

    @Test
    void testAppendHeaderTest() throws IOException {
        this.underTest.appendHeader(1, "Hello World");
        Assertions.assertEquals((Object)String.format("* Hello World%n%n", new Object[0]), (Object)this.sb.toString());
        this.sb.setLength(0);
        this.underTest.appendHeader(2, "Hello World");
        Assertions.assertEquals((Object)String.format("** Hello World%n%n", new Object[0]), (Object)this.sb.toString());
        this.sb.setLength(0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.underTest.appendHeader(0, "Hello World"));
    }

    @Test
    void testAppendListTest() throws IOException {
        String[] entries = new String[]{"one", "two", "three"};
        this.underTest.appendList(true, Arrays.asList(entries));
        Assertions.assertEquals((Object)String.format("    [[1]] one%n    [[2]] two%n    [[3]] three%n%n", new Object[0]), (Object)this.sb.toString());
        this.sb.setLength(0);
        this.underTest.appendList(false, Arrays.asList(entries));
        Assertions.assertEquals((Object)String.format("    * one%n    * two%n    * three%n%n", new Object[0]), (Object)this.sb.toString());
    }

    @Test
    void testAppendParagraphFormatTest() throws IOException {
        this.underTest.appendParagraphFormat("Hello %s World %,d", new Object[]{"Big Joe", 309});
        Assertions.assertEquals((Object)String.format("  Hello Big Joe World 309%n%n", new Object[0]), (Object)this.sb.toString());
    }

    @Test
    void testAppendParagraphTest() throws IOException {
        this.underTest.appendParagraph("Hello World");
        Assertions.assertEquals((Object)String.format("  Hello World%n%n", new Object[0]), (Object)this.sb.toString());
    }

    @Test
    void testAppendTableTest() throws IOException {
        List<TextStyle> styles = Arrays.asList(TextStyle.DEFAULT, TextStyle.DEFAULT, TextStyle.DEFAULT);
        String[] headers = new String[]{"one", "two", "three"};
        List<List> rows = Arrays.asList(Arrays.asList("uno", "dos", "tres"), Arrays.asList("aon", "dh\u00e1", "tr\u00ed"), Arrays.asList("\u0648\u0627\u062d\u062f", "\u0627\u062b\u0646\u064a\u0646", "\u062b\u0644\u0627\u062b\u0629"));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("*-----+-----+-------+");
        expected.add("| one | two | three |");
        expected.add("*-----+-----+-------+");
        expected.add("| uno | dos | tres |");
        expected.add("*-----+-----+-------+");
        expected.add("| aon | dh\u00e1 | tr\u00ed |");
        expected.add("*-----+-----+-------+");
        expected.add("| \u0648\u0627\u062d\u062f | \u0627\u062b\u0646\u064a\u0646 | \u062b\u0644\u0627\u062b\u0629 |");
        expected.add("*-----+-----+-------+");
        expected.add("The caption");
        expected.add("");
        TableDefinition table = TableDefinition.from((String)"The caption", styles, Arrays.asList(headers), rows);
        this.underTest.appendTable(table);
        List actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"full table failed");
        table = TableDefinition.from(null, styles, Arrays.asList(headers), rows);
        expected.remove(9);
        this.sb.setLength(0);
        this.underTest.appendTable(table);
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual);
        table = TableDefinition.from(null, styles, Arrays.asList(headers), Collections.emptyList());
        expected = new ArrayList();
        expected.add("*-----+-----+-------+");
        expected.add("| one | two | three |");
        expected.add("*-----+-----+-------+");
        expected.add("");
        this.sb.setLength(0);
        this.underTest.appendTable(table);
        actual = IOUtils.readLines((Reader)new StringReader(this.sb.toString()));
        Assertions.assertEquals(expected, (Object)actual, (String)"no rows test failed");
    }

    @Test
    void testAppendTitleTest() throws IOException {
        this.sb.setLength(0);
        this.underTest.appendTitle("Hello World");
        Assertions.assertEquals((Object)String.format("        -----%n        Hello World%n        -----%n%nHello World%n%n", new Object[0]), (Object)this.sb.toString());
    }
}

