/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.map;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.map.AbstractSortedMapTest;
import org.apache.commons.collections4.map.PredicatedSortedMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedSortedMapTest<K, V>
extends AbstractSortedMapTest<K, V> {
    protected static final Predicate<Object> truePredicate = TruePredicate.truePredicate();
    protected static final Predicate<Object> testPredicate = String.class::isInstance;
    protected final Comparator<K> reverseStringComparator = new ReverseStringComparator();

    protected SortedMap<K, V> decorateMap(SortedMap<K, V> map, Predicate<? super K> keyPredicate, Predicate<? super V> valuePredicate) {
        return PredicatedSortedMap.predicatedSortedMap(map, keyPredicate, valuePredicate);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAllowNullKey() {
        return false;
    }

    @Override
    public boolean isSubMapViewsSerializable() {
        return false;
    }

    @Override
    public SortedMap<K, V> makeObject() {
        return this.decorateMap(new TreeMap(), truePredicate, truePredicate);
    }

    public SortedMap<K, V> makeTestMap() {
        return this.decorateMap(new TreeMap(), testPredicate, testPredicate);
    }

    public SortedMap<K, V> makeTestMapWithComparator() {
        return this.decorateMap(new ConcurrentSkipListMap(this.reverseStringComparator), testPredicate, testPredicate);
    }

    @Test
    public void testEntrySet() {
        SortedMap<String, String> map = this.makeTestMap();
        Assertions.assertNotNull(map.entrySet(), (String)"returned entryset should not be null");
        map = this.decorateMap(new TreeMap(), null, null);
        map.put("oneKey", "oneValue");
        Assertions.assertEquals((int)1, (int)map.entrySet().size(), (String)"returned entryset should contain one entry");
        map = this.decorateMap(map, null, null);
    }

    @Test
    public void testPut() {
        Map.Entry entry;
        SortedMap<String, String> map = this.makeTestMap();
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.put("Hi", (String)3), (String)"Illegal value should raise IllegalArgument");
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.put((String)3, "Hi"), (String)"Illegal key should raise IllegalArgument");
        Assertions.assertFalse((boolean)map.containsKey(3));
        Assertions.assertFalse((boolean)map.containsValue(3));
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("A", "a");
        map2.put("B", "b");
        map2.put("C", "c");
        map2.put("c", 3);
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.putAll(map2), (String)"Illegal value should raise IllegalArgument");
        map.put("E", "e");
        Iterator iterator = map.entrySet().iterator();
        Map.Entry finalEntry = entry = iterator.next();
        Assertions.assertThrows(IllegalArgumentException.class, () -> finalEntry.setValue((String)3), (String)"Illegal value should raise IllegalArgument");
        map.put("F", "f");
        iterator = map.entrySet().iterator();
        entry = iterator.next();
        entry.setValue("x");
    }

    @Test
    public void testReverseSortOrder() {
        SortedMap<String, String> map = this.makeTestMapWithComparator();
        map.put("A", "a");
        map.put("B", "b");
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.put(null, "c"), (String)"Null key should raise IllegalArgument");
        map.put("C", "c");
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.put("D", null), (String)"Null value should raise IllegalArgument");
        Assertions.assertEquals((Object)"A", map.lastKey(), (String)"Last key should be A");
        Assertions.assertEquals((Object)"C", map.firstKey(), (String)"First key should be C");
        Assertions.assertEquals((Object)"B", (Object)map.tailMap("B").firstKey(), (String)"First key in tail map should be B");
        Assertions.assertEquals((Object)"B", (Object)map.headMap("A").lastKey(), (String)"Last key in head map should be B");
        Assertions.assertEquals((Object)"B", (Object)map.subMap("C", "A").lastKey(), (String)"Last key in submap should be B");
        Comparator<K> c = map.comparator();
        Assertions.assertSame(c, this.reverseStringComparator, (String)"reverse order, so comparator should be reverseStringComparator");
    }

    @Test
    public void testSortOrder() {
        SortedMap<String, String> map = this.makeTestMap();
        map.put("A", "a");
        map.put("B", "b");
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.put(null, "c"), (String)"Null key should raise IllegalArgument");
        map.put("C", "c");
        Assertions.assertThrows(IllegalArgumentException.class, () -> map.put("D", null), (String)"Null value should raise IllegalArgument");
        Assertions.assertEquals((Object)"A", map.firstKey(), (String)"First key should be A");
        Assertions.assertEquals((Object)"C", map.lastKey(), (String)"Last key should be C");
        Assertions.assertEquals((Object)"B", (Object)map.tailMap("B").firstKey(), (String)"First key in tail map should be B");
        Assertions.assertEquals((Object)"B", (Object)map.headMap("C").lastKey(), (String)"Last key in head map should be B");
        Assertions.assertEquals((Object)"B", (Object)map.subMap("A", "C").lastKey(), (String)"Last key in submap should be B");
        Comparator<K> c = map.comparator();
        Assertions.assertNull(c, (String)"natural order, so comparator should be null");
    }

    private final class ReverseStringComparator
    implements Comparator<K> {
        private ReverseStringComparator() {
        }

        @Override
        public int compare(K arg0, K arg1) {
            return ((String)arg1).compareTo((String)arg0);
        }
    }
}

