/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.list.AbstractListTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractLinkedListTest<T>
extends AbstractListTest<T> {
    @Override
    public LinkedList<T> getCollection() {
        return (LinkedList)super.getCollection();
    }

    protected LinkedList<T> getConfirmedLinkedList() {
        return (LinkedList)this.getConfirmed();
    }

    @Override
    public Collection<T> makeConfirmedCollection() {
        return new LinkedList();
    }

    @Override
    public Collection<T> makeConfirmedFullCollection() {
        return new LinkedList(Arrays.asList(this.getFullElements()));
    }

    @Override
    public abstract LinkedList<T> makeObject();

    @Test
    public void testLinkedListAddFirst() {
        if (!this.isAddSupported()) {
            return;
        }
        String o = "hello";
        this.resetEmpty();
        ((LinkedList)this.getCollection()).addFirst(o);
        this.getConfirmedLinkedList().addFirst(o);
        this.verify();
        this.resetFull();
        ((LinkedList)this.getCollection()).addFirst(o);
        this.getConfirmedLinkedList().addFirst(o);
        this.verify();
    }

    @Test
    public void testLinkedListAddLast() {
        if (!this.isAddSupported()) {
            return;
        }
        String o = "hello";
        this.resetEmpty();
        ((LinkedList)this.getCollection()).addLast(o);
        this.getConfirmedLinkedList().addLast(o);
        this.verify();
        this.resetFull();
        ((LinkedList)this.getCollection()).addLast(o);
        this.getConfirmedLinkedList().addLast(o);
        this.verify();
    }

    @Test
    public void testLinkedListGetFirst() {
        this.resetEmpty();
        Assertions.assertThrows(NoSuchElementException.class, () -> ((LinkedList)this.getCollection()).getFirst(), (String)"getFirst() should throw a NoSuchElementException for an empty list.");
        this.verify();
        this.resetFull();
        Object first = ((LinkedList)this.getCollection()).getFirst();
        T confirmedFirst = this.getConfirmedLinkedList().getFirst();
        Assertions.assertEquals(confirmedFirst, first, (String)"Result returned by getFirst() was wrong.");
        this.verify();
    }

    @Test
    public void testLinkedListGetLast() {
        this.resetEmpty();
        Assertions.assertThrows(NoSuchElementException.class, () -> ((LinkedList)this.getCollection()).getLast(), (String)"getLast() should throw a NoSuchElementException for an empty list.");
        this.verify();
        this.resetFull();
        Object last = ((LinkedList)this.getCollection()).getLast();
        T confirmedLast = this.getConfirmedLinkedList().getLast();
        Assertions.assertEquals(confirmedLast, last, (String)"Result returned by getLast() was wrong.");
        this.verify();
    }

    @Test
    public void testLinkedListRemoveFirst() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Assertions.assertThrows(NoSuchElementException.class, () -> ((LinkedList)this.getCollection()).removeFirst(), (String)"removeFirst() should throw a NoSuchElementException for an empty list.");
        this.verify();
        this.resetFull();
        Object first = ((LinkedList)this.getCollection()).removeFirst();
        T confirmedFirst = this.getConfirmedLinkedList().removeFirst();
        Assertions.assertEquals(confirmedFirst, first, (String)"Result returned by removeFirst() was wrong.");
        this.verify();
    }

    @Test
    public void testLinkedListRemoveLast() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.resetEmpty();
        Assertions.assertThrows(NoSuchElementException.class, () -> ((LinkedList)this.getCollection()).removeLast(), (String)"removeLast() should throw a NoSuchElementException for an empty list.");
        this.verify();
        this.resetFull();
        Object last = ((LinkedList)this.getCollection()).removeLast();
        T confirmedLast = this.getConfirmedLinkedList().removeLast();
        Assertions.assertEquals(confirmedLast, last, (String)"Result returned by removeLast() was wrong.");
        this.verify();
    }
}

