/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.GrowthList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class GrowthListTest<E>
extends AbstractListTest<E> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public List<E> makeFullCollection() {
        ArrayList list = new ArrayList(Arrays.asList(this.getFullElements()));
        return GrowthList.growthList(list);
    }

    @Override
    public List<E> makeObject() {
        return new GrowthList();
    }

    @Test
    public void testGrowthAdd() {
        Integer one = 1;
        GrowthList grower = new GrowthList();
        Assertions.assertEquals((int)0, (int)grower.size());
        grower.add(1, (Object)one);
        Assertions.assertEquals((int)2, (int)grower.size());
        Assertions.assertNull((Object)grower.get(0));
        Assertions.assertEquals((Integer)one, (Integer)((Integer)grower.get(1)));
    }

    @Test
    public void testGrowthAddAll() {
        Integer one = 1;
        Integer two = 2;
        ArrayList<Integer> coll = new ArrayList<Integer>();
        coll.add(one);
        coll.add(two);
        GrowthList grower = new GrowthList();
        Assertions.assertEquals((int)0, (int)grower.size());
        grower.addAll(1, coll);
        Assertions.assertEquals((int)3, (int)grower.size());
        Assertions.assertNull((Object)grower.get(0));
        Assertions.assertEquals((Integer)one, (Integer)((Integer)grower.get(1)));
        Assertions.assertEquals((Integer)two, (Integer)((Integer)grower.get(2)));
    }

    @Test
    public void testGrowthList() {
        Integer zero = 0;
        Integer one = 1;
        Integer two = 2;
        GrowthList grower = new GrowthList(1);
        Assertions.assertEquals((int)0, (int)grower.size());
        grower.add(0, (Object)zero);
        Assertions.assertEquals((int)1, (int)grower.size());
        grower.add(1, (Object)one);
        Assertions.assertEquals((int)2, (int)grower.size());
        grower.add(2, (Object)two);
        Assertions.assertEquals((int)3, (int)grower.size());
    }

    @Test
    public void testGrowthSet1() {
        Integer one = 1;
        GrowthList grower = new GrowthList();
        Assertions.assertEquals((int)0, (int)grower.size());
        grower.set(1, (Object)one);
        Assertions.assertEquals((int)2, (int)grower.size());
        Assertions.assertNull((Object)grower.get(0));
        Assertions.assertEquals((Integer)one, (Integer)((Integer)grower.get(1)));
    }

    @Test
    public void testGrowthSet2() {
        Integer one = 1;
        GrowthList grower = new GrowthList();
        Assertions.assertEquals((int)0, (int)grower.size());
        grower.set(0, (Object)one);
        Assertions.assertEquals((int)1, (int)grower.size());
        Assertions.assertEquals((Integer)one, (Integer)((Integer)grower.get(0)));
    }

    @Override
    @Test
    public void testListAddByIndexBoundsChecking() {
        Object element = this.getOtherElements()[0];
        Collection list = this.makeObject();
        Executable testMethod = () -> GrowthListTest.lambda$testListAddByIndexBoundsChecking$0((List)list, element);
        IndexOutOfBoundsException thrown = (IndexOutOfBoundsException)Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)testMethod, (String)"List.add should throw IndexOutOfBoundsException [-1]");
        Assertions.assertEquals((Object)"Index: -1, Size: 0", (Object)thrown.getMessage());
    }

    @Override
    @Test
    public void testListAddByIndexBoundsChecking2() {
        Object element = this.getOtherElements()[0];
        Collection list = this.makeFullCollection();
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> GrowthListTest.lambda$testListAddByIndexBoundsChecking2$1((List)list, element), (String)"List.add should throw IndexOutOfBoundsException [-1]");
    }

    @Override
    @Test
    public void testListSetByIndexBoundsChecking() {
        Collection list = this.makeObject();
        Object element = this.getOtherElements()[0];
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> GrowthListTest.lambda$testListSetByIndexBoundsChecking$2((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [-1]");
    }

    @Override
    @Test
    public void testListSetByIndexBoundsChecking2() {
        Collection list = this.makeFullCollection();
        Object element = this.getOtherElements()[0];
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> GrowthListTest.lambda$testListSetByIndexBoundsChecking2$3((List)list, element), (String)"List.set should throw IndexOutOfBoundsException [-1]");
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking2$3(List list, Object element) throws Throwable {
        list.set(-1, element);
    }

    private static /* synthetic */ void lambda$testListSetByIndexBoundsChecking$2(List list, Object element) throws Throwable {
        list.set(-1, element);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking2$1(List list, Object element) throws Throwable {
        list.add(-1, element);
    }

    private static /* synthetic */ void lambda$testListAddByIndexBoundsChecking$0(List list, Object element) throws Throwable {
        list.add(-1, element);
    }
}

