/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CpioArchiveOutputStreamTest
extends AbstractTest {
    CpioArchiveOutputStreamTest() {
    }

    @Test
    void testWriteOldBinary() throws Exception {
        CpioArchiveOutputStream ref;
        File file = CpioArchiveOutputStreamTest.getFile("test1.xml");
        File output = this.newTempFile("test.cpio");
        try (CpioArchiveOutputStream outputStream = new CpioArchiveOutputStream(Files.newOutputStream(output.toPath(), new OpenOption[0]), 8);){
            ref = outputStream;
            outputStream.putArchiveEntry(new CpioArchiveEntry(8, file, "test1.xml"));
            outputStream.write(file);
            outputStream.closeArchiveEntry();
        }
        Assertions.assertTrue((boolean)ref.isClosed());
        try (CpioArchiveInputStream in = new CpioArchiveInputStream(Files.newInputStream(output.toPath(), new OpenOption[0]));){
            CpioArchiveEntry e = in.getNextCPIOEntry();
            Assertions.assertEquals((Object)"test1.xml", (Object)e.getName());
            Assertions.assertNull((Object)in.getNextEntry());
        }
    }
}

