/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class CpioArchiveTest {
    CpioArchiveTest() {
    }

    public static Stream<Arguments> factory() {
        return Stream.of(Arguments.of((Object[])new Object[]{(short)1}), Arguments.of((Object[])new Object[]{(short)2}), Arguments.of((Object[])new Object[]{(short)4}), Arguments.of((Object[])new Object[]{(short)8}));
    }

    @Test
    void utf18RoundtripTestCtor2() throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (CpioArchiveOutputStream os = new CpioArchiveOutputStream((OutputStream)baos, StandardCharsets.UTF_8.name());){
                CpioArchiveEntry entry = new CpioArchiveEntry("Test.txt", 4L);
                os.putArchiveEntry(entry);
                os.write(new byte[]{1, 2, 3, 4});
                os.closeArchiveEntry();
            }
            baos.close();
            try (ByteArrayInputStream bin = new ByteArrayInputStream(baos.toByteArray());
                 CpioArchiveInputStream in = new CpioArchiveInputStream((InputStream)bin, StandardCharsets.UTF_8.name());){
                CpioArchiveEntry entry = in.getNextEntry();
                Assertions.assertNotNull((Object)entry);
                Assertions.assertEquals((Object)"Test.txt", (Object)entry.getName());
                Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])IOUtils.toByteArray((InputStream)in));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void utf18RoundtripTestCtor3(short format) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (CpioArchiveOutputStream os = new CpioArchiveOutputStream((OutputStream)baos, format, 512);){
                CpioArchiveEntry entry = new CpioArchiveEntry(format, "T\u00e4st.txt", 4L);
                if (format == 2) {
                    entry.setChksum(10L);
                }
                os.putArchiveEntry(entry);
                os.write(new byte[]{1, 2, 3, 4});
                os.closeArchiveEntry();
            }
            baos.close();
            try (ByteArrayInputStream bin = new ByteArrayInputStream(baos.toByteArray());
                 CpioArchiveInputStream in = new CpioArchiveInputStream((InputStream)bin);){
                CpioArchiveEntry entry = in.getNextEntry();
                Assertions.assertNotNull((Object)entry);
                Assertions.assertEquals((Object)"T%U00E4st.txt", (Object)entry.getName());
                Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])IOUtils.toByteArray((InputStream)in));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"factory"})
    public void utf18RoundtripTestCtor4(short format) throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (CpioArchiveOutputStream os = new CpioArchiveOutputStream((OutputStream)baos, format, 512, StandardCharsets.UTF_16LE.name());){
                CpioArchiveEntry entry = new CpioArchiveEntry(format, "T\u00e4st.txt", 4L);
                if (format == 2) {
                    entry.setChksum(10L);
                }
                os.putArchiveEntry(entry);
                os.write(new byte[]{1, 2, 3, 4});
                os.closeArchiveEntry();
            }
            baos.close();
            try (ByteArrayInputStream bin = new ByteArrayInputStream(baos.toByteArray());
                 CpioArchiveInputStream in = new CpioArchiveInputStream((InputStream)bin, StandardCharsets.UTF_16LE.name());){
                CpioArchiveEntry entry = in.getNextEntry();
                Assertions.assertNotNull((Object)entry);
                Assertions.assertEquals((Object)"T\u00e4st.txt", (Object)entry.getName());
                Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4}, (byte[])IOUtils.toByteArray((InputStream)in));
            }
        }
    }
}

