/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTempDirTest;
import org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ScatterZipOutputStreamTest
extends AbstractTempDirTest {
    ScatterZipOutputStreamTest() {
    }

    private InputStreamSupplier createPayloadSupplier(ByteArrayInputStream payload) {
        return () -> payload;
    }

    @Test
    void testPutArchiveEntry() throws Exception {
        File scatterFile = this.createTempFile("scattertest", ".notzip");
        File target = this.createTempFile("scattertest", ".zip");
        byte[] B_PAYLOAD = "RBBBBBBS".getBytes();
        byte[] A_PAYLOAD = "XAAY".getBytes();
        try (ScatterZipOutputStream scatterZipOutputStream = ScatterZipOutputStream.fileBased((File)scatterFile);){
            ZipArchiveEntry zab = new ZipArchiveEntry("b.txt");
            zab.setMethod(8);
            ByteArrayInputStream payload = new ByteArrayInputStream(B_PAYLOAD);
            scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zab, (InputStreamSupplier)this.createPayloadSupplier(payload)));
            ZipArchiveEntry zae = new ZipArchiveEntry("a.txt");
            zae.setMethod(8);
            ByteArrayInputStream payload1 = new ByteArrayInputStream(A_PAYLOAD);
            scatterZipOutputStream.addArchiveEntry(ZipArchiveEntryRequest.createZipArchiveEntryRequest((ZipArchiveEntry)zae, (InputStreamSupplier)this.createPayloadSupplier(payload1)));
            try (ZipArchiveOutputStream outputStream = new ZipArchiveOutputStream(target);){
                scatterZipOutputStream.writeTo(outputStream);
            }
        }
        try (ZipFile zf = ((ZipFile.Builder)ZipFile.builder().setFile(target)).get();){
            ZipArchiveEntry bEntry = (ZipArchiveEntry)zf.getEntries("b.txt").iterator().next();
            Assertions.assertEquals((long)8L, (long)bEntry.getSize());
            try (InputStream inputStream = zf.getInputStream(bEntry);){
                Assertions.assertArrayEquals((byte[])B_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
            }
            ZipArchiveEntry aEntry = (ZipArchiveEntry)zf.getEntries("a.txt").iterator().next();
            Assertions.assertEquals((long)4L, (long)aEntry.getSize());
            try (InputStream inputStream = zf.getInputStream(aEntry);){
                Assertions.assertArrayEquals((byte[])A_PAYLOAD, (byte[])IOUtils.toByteArray((InputStream)inputStream));
            }
        }
    }
}

