/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.compress.utils.FileNameUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FileNameUtilsTest {
    FileNameUtilsTest() {
    }

    @Test
    void testGetBaseNamePathBaseCases() {
        Assertions.assertEquals((Object)"bar", (Object)FileNameUtils.getBaseName((Path)Paths.get("a/b/c/bar.foo", new String[0])));
        Assertions.assertEquals((Object)"foo", (Object)FileNameUtils.getBaseName((Path)Paths.get("foo", new String[0])));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getBaseName((Path)Paths.get("", new String[0])));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getBaseName((Path)Paths.get(".", new String[0])));
        for (File f : File.listRoots()) {
            Assertions.assertNull((Object)FileNameUtils.getBaseName((Path)f.toPath()));
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertNull((Object)FileNameUtils.getBaseName((Path)Paths.get("C:\\", new String[0])));
        }
    }

    @Test
    void testGetBaseNamePathCornerCases() {
        Assertions.assertNull((Object)FileNameUtils.getBaseName((Path)null));
        Assertions.assertEquals((Object)"foo", (Object)FileNameUtils.getBaseName((Path)Paths.get("foo.", new String[0])));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getBaseName((Path)Paths.get("bar/.foo", new String[0])));
    }

    @Test
    void testGetBaseNameStringBaseCases() {
        Assertions.assertEquals((Object)"bar", (Object)FileNameUtils.getBaseName((String)"a/b/c/bar.foo"));
        Assertions.assertEquals((Object)"foo", (Object)FileNameUtils.getBaseName((String)"foo"));
    }

    @Test
    void testGetBaseNameStringCornerCases() {
        Assertions.assertNull((Object)FileNameUtils.getBaseName((String)null));
        Assertions.assertEquals((Object)"foo", (Object)FileNameUtils.getBaseName((String)"foo."));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getBaseName((String)"bar/.foo"));
    }

    @Test
    void testGetExtensionPathBaseCases() {
        Assertions.assertEquals((Object)"foo", (Object)FileNameUtils.getExtension((Path)Paths.get("a/b/c/bar.foo", new String[0])));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getExtension((Path)Paths.get("foo", new String[0])));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getExtension((Path)Paths.get("", new String[0])));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getExtension((Path)Paths.get(".", new String[0])));
        for (File f : File.listRoots()) {
            Assertions.assertNull((Object)FileNameUtils.getExtension((Path)f.toPath()));
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertNull((Object)FileNameUtils.getExtension((Path)Paths.get("C:\\", new String[0])));
        }
    }

    @Test
    void testGetExtensionPathCornerCases() {
        Assertions.assertNull((Object)FileNameUtils.getExtension((String)null));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getExtension((Path)Paths.get("foo.", new String[0])));
        Assertions.assertEquals((Object)"foo", (Object)FileNameUtils.getExtension((Path)Paths.get("bar/.foo", new String[0])));
    }

    @Test
    void testGetExtensionStringBaseCases() {
        Assertions.assertEquals((Object)"foo", (Object)FileNameUtils.getExtension((String)"a/b/c/bar.foo"));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getExtension((String)"foo"));
    }

    @Test
    void testGetExtensionStringCornerCases() {
        Assertions.assertNull((Object)FileNameUtils.getExtension((String)null));
        Assertions.assertEquals((Object)"", (Object)FileNameUtils.getExtension((String)"foo."));
        Assertions.assertEquals((Object)"foo", (Object)FileNameUtils.getExtension((String)"bar/.foo"));
    }
}

